package com.ruoyi.system.service.grid;

import com.github.pagehelper.PageInfo;
import com.ruoyi.system.domain.grid.GridCompanyLawArchives;
import com.ruoyi.system.domain.grid.GridCompanyLawArchivesExample;
import com.ruoyi.system.domain.grid.ext.GridCompanyLawArchivesExt;
import com.ruoyi.system.domain.grid.vo.GridCompanyLawArchivesParam;
import com.ruoyi.system.service.BaseService;

public interface GridCompanyLawArchivesService extends BaseService<GridCompanyLawArchives, GridCompanyLawArchivesExample> {

    /**
     * 分页查询安监检查列表
     */
    PageInfo pageInfos(GridCompanyLawArchivesParam check, Integer pageNo, Integer pageSize);

    /**
     * 获取安监检查详情
     */
    GridCompanyLawArchivesExt detail(String id);

    /**
     * 保存安监检查
     */
    void save(GridCompanyLawArchivesExt archivesExt);

    /**
     * 更新安监检查
     */
    void update(GridCompanyLawArchivesExt archivesExt);

    /**
     * 删除安监检查
     */
    void delete(String id);
}
