package com.ruoyi.system.domain.qcc.enums;


import com.ruoyi.common.exception.ServiceException;

public enum EsearchWayEnum {

    vague("vague","模糊查询"),
    precise("precise","精准查询"),
    bank("bank","银行信息查询");

    private String mode;

    private String name;

    public String getMode() {
        return mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    EsearchWayEnum(String mode, String name) {
        this.mode = mode;
        this.name = name;
    }

    public static EsearchWayEnum getByMode(String mode) {
        for (EsearchWayEnum m : EsearchWayEnum.values()) {
            if (m.getMode().equals(mode)) {
                return m;
            }
        }
        throw new ServiceException("该方式不识别");
    }
}
