package com.ruoyi.common.zqt;

import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;

import static java.util.concurrent.TimeUnit.SECONDS;

public class ZQTConcurrencyHelper
{
    private static ThreadPoolExecutor executor;
    static {
        executor = new ThreadPoolExecutor(10, 100, 10, SECONDS,new ArrayBlockingQueue<Runnable>(5000), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public static void doSth(Runnable runnable){
        executor.submit(runnable);
    }

    public static void doMutli(List<Runnable> runnables){
        if(CollectionUtils.isEmpty(runnables)){
            return;
        }
        CountDownLatch downLatch = new CountDownLatch(runnables.size());
        for(Runnable runnable : runnables){
            executor.submit(() -> {
                runnable.run();
                downLatch.countDown();
            });
        }

        try {
            downLatch.await();
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

}
