package com.ruoyi.web.controller.party;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.party.domain.PartyOrganizationError;
import com.ruoyi.party.service.api.IPartyOrganizationErrorService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 党组织管理Controller
 * 
 * @author ruoyi
 * @date 2024-05-21
 */
@Api(tags = "党组织管理")
@RestController
@RequestMapping("/api/party/partyOrganization/error")
public class PartyOrganizationErrorController extends BaseController
{
    @Autowired
    private IPartyOrganizationErrorService partyOrganizationErrorService;

    /**
     * 查询党组织管理列表
     */
    @PreAuthorize("@ss.hasPermi('system:error:list')")
    @GetMapping("/list")
    public TableDataInfo list(PartyOrganizationError partyOrganizationError)
    {
        startPage();
        List<PartyOrganizationError> list = partyOrganizationErrorService.selectPartyOrganizationErrorList(partyOrganizationError);
        return getDataTable(list);
    }

    /**
     * 导出党组织管理列表
     */
    @PreAuthorize("@ss.hasPermi('system:error:export')")
    @Log(title = "党组织管理", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, PartyOrganizationError partyOrganizationError)
    {
        List<PartyOrganizationError> list = partyOrganizationErrorService.selectPartyOrganizationErrorList(partyOrganizationError);
        ExcelUtil<PartyOrganizationError> util = new ExcelUtil<PartyOrganizationError>(PartyOrganizationError.class);
        util.exportExcel(response, list, "党组织管理数据");
    }

    /**
     * 获取党组织管理详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:error:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(partyOrganizationErrorService.selectPartyOrganizationErrorById(id));
    }

    /**
     * 新增党组织管理
     */
    @PreAuthorize("@ss.hasPermi('system:error:add')")
    @Log(title = "党组织管理", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody PartyOrganizationError partyOrganizationError)
    {
        return toAjax(partyOrganizationErrorService.insertPartyOrganizationError(partyOrganizationError));
    }

    /**
     * 修改党组织管理
     */
    @PreAuthorize("@ss.hasPermi('system:error:edit')")
    @Log(title = "党组织管理", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody PartyOrganizationError partyOrganizationError)
    {
        return toAjax(partyOrganizationErrorService.updatePartyOrganizationError(partyOrganizationError));
    }

    /**
     * 删除党组织管理
     */
    @PreAuthorize("@ss.hasPermi('system:error:remove')")
    @Log(title = "党组织管理", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(partyOrganizationErrorService.deletePartyOrganizationErrorByIds(ids));
    }
}
