package com.ruoyi.web.controller.operatingmanage;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.annotation.RepeatSubmit;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.domain.operatingmanage.TOperatingmanageNotice;
import com.ruoyi.system.service.operatingmanage.TOperatingmanageNoticeService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 通知公告
 * @author wujm<wujm@eazytec.com>
 */
@Api(tags = "运营管理-通知公告")
@RestController
@RequestMapping("/api/operatingmanage/notice")
public class TOperatingmanageNoticeController extends BaseController {
	
	@Autowired
	private TOperatingmanageNoticeService tOperatingngmanageNoticeService;
	/**
	 * 列表
	 * @param tOperatingmanageNotice
	 * @return
	 */
	@GetMapping("/list")
	public TableDataInfo list(TOperatingmanageNotice tOperatingmanageNotice) {
		startPage();
		return getDataTable(tOperatingngmanageNoticeService.listTOperatingmanageNotice(tOperatingmanageNotice, getUserId()));
	}


		
	/**
	 * 新增
	 * @param tOperatingmanageNotice
	 * @return
	 */
	@Log(title = "新增通知公告", businessType = BusinessType.INSERT)
	@RepeatSubmit
	@PostMapping("/add")
	public AjaxResult save(@RequestBody TOperatingmanageNotice tOperatingmanageNotice) {
		if (StringUtils.isNull(tOperatingmanageNotice.getNoticeRange()) || tOperatingmanageNotice.getNoticeRange().isEmpty()) {
			throw new ServiceException("发布范围");
		}
		tOperatingmanageNotice.setUpdateBy(getUsername());
		return toAjax(tOperatingngmanageNoticeService.saveTOperatingmanageNotice(tOperatingmanageNotice, getUserId()));
	}
	
	/**
	 * 根据id查询详情
	 * @param id
	 * @return
	 */
	@GetMapping("/{id}")
	public AjaxResult getById(@PathVariable("id") Long id) {
		TOperatingmanageNotice tOperatingmanageNotice = tOperatingngmanageNoticeService.getTOperatingmanageNoticeById(id);
		if(tOperatingmanageNotice != null && StringUtils.isNotBlank(tOperatingmanageNotice.getNoticeContent())){
			String content = tOperatingmanageNotice.getNoticeContent().replaceAll("<image ", "<img ");
			tOperatingmanageNotice.setNoticeContent(content);
		}
		return AjaxResult.success(tOperatingmanageNotice);
	}
	
	/**
	 * 修改
	 * @param tOperatingmanageNotice
	 * @return
	 */
	@Log(title = "修改通知公告", businessType = BusinessType.UPDATE)
	@PutMapping("/update")
	public AjaxResult update(@RequestBody TOperatingmanageNotice tOperatingmanageNotice) {
		if (StringUtils.isEmpty(tOperatingmanageNotice.getNoticeRange())) {
			throw new ServiceException("发布范围");
		}
		tOperatingmanageNotice.setUpdateBy(getUsername());
		return toAjax(tOperatingngmanageNoticeService.updateTOperatingmanageNotice(tOperatingmanageNotice));
	}
	
	/**
	 * 删除
	 * @param ids
	 * @return
	 */
	@Log(title = "删除通知公告", businessType = BusinessType.DELETE)
	@DeleteMapping("/delete")
	public AjaxResult batchRemove(@RequestBody Long[] ids) {
		return toAjax(tOperatingngmanageNoticeService.batchRemove(ids));
	}

	/**
	 * 修改基础信息，不处理影响范围
	 * @param id
	 * @param tOperatingmanageNotice
	 * @return
	 */
	@Log(title = "修改通知公告", businessType = BusinessType.UPDATE)
	@PutMapping("/update/{id}")
	public AjaxResult basic(@PathVariable("id") Long id,@RequestBody TOperatingmanageNotice tOperatingmanageNotice) {
		tOperatingmanageNotice.setNoticeId(id);
		tOperatingmanageNotice.setUpdateBy(getUsername());
		return toAjax(tOperatingngmanageNoticeService.basicTOperatingmanageNotice(tOperatingmanageNotice));
	}
}
