package com.ruoyi.web.controller.house;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.system.domain.house.HouseResource;
import com.ruoyi.system.domain.house.vo.*;
import com.ruoyi.system.service.house.HouseResourceService;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@RestController
@RequestMapping("/api/house")
public class HouseResourceController {

    private final HouseResourceService houseResourceService;

    public HouseResourceController(HouseResourceService houseResourceService) {
        this.houseResourceService = houseResourceService;
    }

//    @PreAuthorize("@ss.hasPermi('system:house:add')")
    @PostMapping
    public AjaxResult saveHouseResource(@RequestBody HouseResourceSaveUpdateDto dto) {
        houseResourceService.saveHouseResource(dto);
        return AjaxResult.success();
    }

    @GetMapping
    public AjaxResult getHouseResourceById(@RequestParam String id) {
        return AjaxResult.success(houseResourceService.detail(id));
    }

//    @PreAuthorize("@ss.hasPermi('system:house:edit')")
    @PutMapping
    public AjaxResult updateHouseResource(@RequestBody HouseResourceSaveUpdateDto dto) {
        houseResourceService.updateHouseResource(dto);
        return AjaxResult.success();
    }

//    @PreAuthorize("@ss.hasPermi('system:house:remove')")
    @DeleteMapping
    public AjaxResult deleteHouseResourceById(@RequestParam String id) {
        houseResourceService.deleteHouseResourceById(id);
        return AjaxResult.success();
    }

    @PostMapping("/batch")
    public AjaxResult batchSaveHouseResources(@RequestBody List<HouseResource> houseResources) {
        houseResourceService.batchSaveHouseResources(houseResources);
        return AjaxResult.success();
    }

    @PostMapping("/page")
    public AjaxResult getPageHouseResources(@RequestBody HouseResourcePageQuery query) {
        if (Objects.nonNull(query.getIncomeSort()) && query.getIncomeSort().length() > 4) {
            return AjaxResult.error("<UNK>4<UNK>");
        }
        return AjaxResult.success(houseResourceService.pageHouseResources(query));
    }

    @PostMapping("/profileGraph")
    public AjaxResult getProfileGraphHouseResources(@RequestBody HouseResourcePageQuery query) {
        return AjaxResult.success(houseResourceService.profileGraphHouseResources(query));
    }

    @GetMapping("/app/profileGraph")
    public AjaxResult getAppProfileGraphHouseResources(HouseResourcePageQuery query) {
        return AjaxResult.success(houseResourceService.appProfileGraphHouseResources(query));
    }

    @PostMapping("/list")
    public AjaxResult getListHouseResources(@RequestBody HouseResourcePageQuery query) {
        return AjaxResult.success(houseResourceService.listHouseResources(query));
    }

    @PostMapping("/businessEntityStatistics")
    public AjaxResult getBusinessEntityStatistics(@RequestBody HouseResourcePageQuery query) {
        return AjaxResult.success(houseResourceService.businessEntityStatistics(query));
    }

    @PostMapping("/page/businessEntityStatistics")
    public AjaxResult getPageBusinessEntityStatistics(@RequestBody PageBusinessEntityStatisticsQuery query) {
        return AjaxResult.success(houseResourceService.pageBusinessEntityStatistics(query));
    }

    @PostMapping("/saveYearTax")
    public AjaxResult postSaveYearTax(@RequestBody YearTaxSaveUpdateDto dto) {
        houseResourceService.saveYearTax(dto);
        return AjaxResult.success();
    }

    @PostMapping("/export")
    public void export(HttpServletResponse response, @RequestBody HouseResourcePageQuery query) {
        List<HouseResourceExport> exportList = new ArrayList<>();
        List<HouseResourcePage> pageList = houseResourceService.exportListHouseResources(query);
        pageList.forEach(x -> {
            HouseResourceExport houseResourceExport = new HouseResourceExport();
            BeanUtils.copyProperties(x, houseResourceExport);
            exportList.add(houseResourceExport);
        });
        ExcelUtil<HouseResourceExport> util = new ExcelUtil<>(HouseResourceExport.class);
        util.exportExcel(response, exportList, "房源数据");
    }

    @GetMapping("/businessEntityInfo")
    public AjaxResult getBusinessEntityInfo(@RequestParam("name") String name) {
        return AjaxResult.success(houseResourceService.listByBusinessEntityInfoName(name));
    }
}
