package com.ruoyi.party.service.impl;

import com.ruoyi.common.annotation.DataSource;
import com.ruoyi.common.enums.DataSourceType;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.party.domain.PartyOrganizationError;
import com.ruoyi.party.mapper.PartyOrganizationErrorMapper;
import com.ruoyi.party.service.api.IPartyOrganizationErrorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 党组织管理Service业务层处理
 * 
 * @author ruoyi
 * @date 2024-05-21
 */
@Service
@DataSource(value = DataSourceType.SLAVE)
public class PartyOrganizationErrorServiceImpl implements IPartyOrganizationErrorService
{
    @Autowired
    private PartyOrganizationErrorMapper partyOrganizationErrorMapper;

    /**
     * 查询党组织管理
     * 
     * @param id 党组织管理主键
     * @return 党组织管理
     */
    @Override
    public PartyOrganizationError selectPartyOrganizationErrorById(Long id)
    {
        return partyOrganizationErrorMapper.selectPartyOrganizationErrorById(id);
    }

    /**
     * 查询党组织管理列表
     * 
     * @param partyOrganizationError 党组织管理
     * @return 党组织管理
     */
    @Override
    public List<PartyOrganizationError> selectPartyOrganizationErrorList(PartyOrganizationError partyOrganizationError)
    {
        return partyOrganizationErrorMapper.selectPartyOrganizationErrorList(partyOrganizationError);
    }

    /**
     * 新增党组织管理
     * 
     * @param partyOrganizationError 党组织管理
     * @return 结果
     */
    @Override
    public int insertPartyOrganizationError(PartyOrganizationError partyOrganizationError)
    {
        partyOrganizationError.setCreateTime(DateUtils.getNowDate());
        return partyOrganizationErrorMapper.insertPartyOrganizationError(partyOrganizationError);
    }

    /**
     * 修改党组织管理
     * 
     * @param partyOrganizationError 党组织管理
     * @return 结果
     */
    @Override
    public int updatePartyOrganizationError(PartyOrganizationError partyOrganizationError)
    {
        return partyOrganizationErrorMapper.updatePartyOrganizationError(partyOrganizationError);
    }

    /**
     * 批量删除党组织管理
     * 
     * @param ids 需要删除的党组织管理主键
     * @return 结果
     */
    @Override
    public int deletePartyOrganizationErrorByIds(Long[] ids)
    {
        return partyOrganizationErrorMapper.deletePartyOrganizationErrorByIds(ids);
    }

    /**
     * 删除党组织管理信息
     * 
     * @param id 党组织管理主键
     * @return 结果
     */
    @Override
    public int deletePartyOrganizationErrorById(Long id)
    {
        return partyOrganizationErrorMapper.deletePartyOrganizationErrorById(id);
    }
}
