package com.ruoyi.party.service.impl;

import com.ruoyi.common.annotation.DataSource;
import com.ruoyi.common.enums.DataSourceType;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.party.domain.PartyMemberError;
import com.ruoyi.party.mapper.PartyMemberErrorMapper;
import com.ruoyi.party.service.api.IPartyMemberErrorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 党员Service业务层处理
 * 
 * @author ruoyi
 * @date 2024-05-21
 */
@Service
@DataSource(value = DataSourceType.SLAVE)
public class PartyMemberErrorServiceImpl implements IPartyMemberErrorService
{
    @Autowired
    private PartyMemberErrorMapper partyMemberErrorMapper;

    /**
     * 查询党员
     * 
     * @param id 党员主键
     * @return 党员
     */
    @Override
    public PartyMemberError selectPartyMemberErrorById(Long id)
    {
        return partyMemberErrorMapper.selectPartyMemberErrorById(id);
    }

    /**
     * 查询党员列表
     * 
     * @param partyMemberError 党员
     * @return 党员
     */
    @Override
    public List<PartyMemberError> selectPartyMemberErrorList(PartyMemberError partyMemberError)
    {
        return partyMemberErrorMapper.selectPartyMemberErrorList(partyMemberError);
    }

    /**
     * 新增党员
     * 
     * @param partyMemberError 党员
     * @return 结果
     */
    @Override
    public int insertPartyMemberError(PartyMemberError partyMemberError)
    {
        partyMemberError.setCreateTime(DateUtils.getNowDate());
        return partyMemberErrorMapper.insertPartyMemberError(partyMemberError);
    }

    /**
     * 修改党员
     * 
     * @param partyMemberError 党员
     * @return 结果
     */
    @Override
    public int updatePartyMemberError(PartyMemberError partyMemberError)
    {
        return partyMemberErrorMapper.updatePartyMemberError(partyMemberError);
    }

    /**
     * 批量删除党员
     * 
     * @param ids 需要删除的党员主键
     * @return 结果
     */
    @Override
    public int deletePartyMemberErrorByIds(Long[] ids)
    {
        return partyMemberErrorMapper.deletePartyMemberErrorByIds(ids);
    }

    /**
     * 删除党员信息
     * 
     * @param id 党员主键
     * @return 结果
     */
    @Override
    public int deletePartyMemberErrorById(Long id)
    {
        return partyMemberErrorMapper.deletePartyMemberErrorById(id);
    }
}
