package com.ruoyi.party.service.impl;

import com.ruoyi.common.annotation.DataSource;
import com.ruoyi.common.core.domain.entity.SysDictData;
import com.ruoyi.common.enums.DataSourceType;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.party.domain.PartyActivity;
import com.ruoyi.party.domain.PartyOrganization;
import com.ruoyi.party.domain.vo.PartyActivityVO;
import com.ruoyi.party.mapper.PartyActivityMapper;
import com.ruoyi.party.mapper.PartyOrganizationMapper;
import com.ruoyi.party.service.api.IPartyActivityService;
import com.ruoyi.system.mapper.system.SysDictDataMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;


/**
 * 党员活动Service业务层处理
 * 
 * @author ruoyi
 * @date 2024-05-15
 */
@Service
@DataSource(value = DataSourceType.SLAVE)
public class PartyActivityServiceImpl implements IPartyActivityService
{
    @Autowired
    private PartyActivityMapper partyActivityMapper;

    @Autowired
    private PartyOrganizationMapper partyOrganizationMapper;

    /**
     * 查询党员活动
     * 
     * @param id 党员活动主键
     * @return 党员活动
     */
    @Override
    public PartyActivityVO selectPartyActivityById(String id)
    {
        PartyActivity partyActivity = partyActivityMapper.selectPartyActivityById(id);
        PartyActivityVO partyActivityVO = new PartyActivityVO();
        BeanUtils.copyProperties(partyActivity, partyActivityVO);
        if(StringUtils.isNotBlank(partyActivity.getSsdzzmc())){
            PartyOrganization partyOrganization = partyOrganizationMapper.getByDzzdm(partyActivity.getSsdzzmc());
            partyActivityVO.setDzzName(partyOrganization == null?"": partyOrganization.getDzzmc());
        }
        return partyActivityVO;
    }

    /**
     * 查询党员活动列表
     * 
     * @param partyActivity 党员活动
     * @return 党员活动
     */
    @Override
    public List<PartyActivity> selectPartyActivityList(PartyActivity partyActivity)
    {
        return partyActivityMapper.selectPartyActivityList(partyActivity);
    }

    @Override
    public List<PartyActivity> convertData(List<PartyActivity> list, List<SysDictData> dictDataList) {
        Map<String, SysDictData> map  = new HashMap<>();
        if (!dictDataList.isEmpty()) {
            map  = dictDataList.stream().collect(Collectors.toMap(SysDictData::getDictValue, x -> x));
        }
        Map<String, SysDictData> finalMap = map;
        return list.stream().map(activity -> {
            SysDictData sysDictData = finalMap.get(activity.getFwlx());
            if (sysDictData != null) {
                activity.setFwlxString(sysDictData.getDictLabel());
            }
            PartyOrganization partyOrganization = partyOrganizationMapper.getByDzzdm(activity.getSsdzzmc());
            activity.setDzzValue(partyOrganization == null?"":partyOrganization.getDzzmc());
            return activity;
        }).collect(Collectors.toList());
    }

    /**
     * 新增党员活动
     * 
     *
     * @return 结果
     */
    @Override
    public Boolean insertOrUpdatePartyActivity(PartyActivity parms)
    {
        if(StringUtils.isNotBlank(parms.getSsdzzmc())){
            PartyOrganization partyOrganization = partyOrganizationMapper.getByDzzdm(parms.getSsdzzmc());
            parms.setWgCode(partyOrganization == null?"":partyOrganization.getSswg());
        }
        if (StringUtils.isNotEmpty(parms.getId())) {
            parms.setUpdateTime(new Date());
            partyActivityMapper.updatePartyActivity(parms);
        } else {
            parms.setId(UUID.randomUUID().toString());
            parms.setCreateTime(DateUtils.getNowDate());
            partyActivityMapper.insertPartyActivity(parms);

        }
        return true;
    }

    /**
     * 修改党员活动
     * 
     * @param partyActivity 党员活动
     * @return 结果
     */
    @Override
    public int updatePartyActivity(PartyActivity partyActivity)
    {
        if(StringUtils.isNotBlank(partyActivity.getSsdzzmc())){
            PartyOrganization partyOrganization = partyOrganizationMapper.getByDzzdm(partyActivity.getSsdzzmc());
            partyActivity.setWgCode(partyOrganization == null?"":partyOrganization.getSswg());
        }
        return partyActivityMapper.updatePartyActivity(partyActivity);
    }

    /**
     * 批量删除党员活动
     * 
     * @param ids 需要删除的党员活动主键
     * @return 结果
     */
    @Override
    public int deletePartyActivityByIds(String[] ids)
    {
        return partyActivityMapper.deletePartyActivityByIds(ids);
    }

    /**
     * 删除党员活动信息
     * 
     * @param id 党员活动主键
     * @return 结果
     */
    @Override
    public int deletePartyActivityById(String id)
    {
        return partyActivityMapper.deletePartyActivityById(id);
    }

    @Override
    public List<Map<String, Object>> getPartyActivity(String orgId) {
        return partyActivityMapper.getPartyActivity(orgId);
    }
}
