package com.ruoyi.party.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ruoyi.party.domain.PartyOrganization;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 党组织管理Mapper接口
 * 
 * @author ruoyi
 * @date 2024-05-17
 */
public interface PartyOrganizationMapper extends BaseMapper<PartyOrganization>
{
    /**
     * 查询党组织管理
     * 
     * @param id 党组织管理主键
     * @return 党组织管理
     */
    public PartyOrganization selectPartyOrganizationById(String id);

    /**
     * 查询党组织管理列表
     * 
     * @param partyOrganization 党组织管理
     * @return 党组织管理集合
     */
    public List<PartyOrganization> selectPartyOrganizationList(PartyOrganization partyOrganization);

    /**
     * 新增党组织管理
     * 
     * @param partyOrganization 党组织管理
     * @return 结果
     */
    public int insertPartyOrganization(PartyOrganization partyOrganization);

    /**
     * 修改党组织管理
     * 
     * @param partyOrganization 党组织管理
     * @return 结果
     */
    public int updatePartyOrganization(PartyOrganization partyOrganization);

    /**
     * 删除党组织管理
     * 
     * @param id 党组织管理主键
     * @return 结果
     */
    public int deletePartyOrganizationById(String id);

    /**
     * 批量删除党组织管理
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deletePartyOrganizationByIds(String[] ids);


    public int countOrg();

    public List<Map<String, String>> getPartyOrgBuild();

    /**
     * 根据党组织代码获取党组织
     * @param dzzdm
     * @return
     */
    PartyOrganization getByDzzdm(@Param("dzzdm") String dzzdm);

    PartyOrganization getByDzzmc(@Param("dzzmc") String dzzmc);

}
