package com.ruoyi.party.mapper;

import com.ruoyi.party.domain.ExcellentParty;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 优秀党组织Mapper接口
 * 
 * @author ruoyi
 * @date 2024-05-20
 */
public interface ExcellentPartyMapper 
{
    /**
     * 查询优秀党组织
     * 
     * @param id 优秀党组织主键
     * @return 优秀党员
     */
    public ExcellentParty selectExcellentPartyById(String id);

    /**
     * 查询优秀党组织列表
     * 
     * @param excellentParty 优秀党组织
     * @return 优秀党组织集合
     */
    public List<ExcellentParty> selectExcellentPartyList(ExcellentParty excellentParty);

    /**
     * 新增优秀党员
     * 
     * @param excellentParty 优秀党组织
     * @return 结果
     */
    public int insertExcellentParty(ExcellentParty excellentParty);

    /**
     * 修改优秀党员
     * 
     * @param excellentParty 优秀党组织
     * @return 结果
     */
    public int updateExcellentParty(ExcellentParty excellentParty);

    /**
     * 删除优秀党组织
     * 
     * @param id 优秀党组织主键
     * @return 结果
     */
    public int deleteExcellentPartyById(String id);

    /**
     * 批量删除优秀党组织
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteExcellentPartyByIds(String[] ids);


    public String getGoodPartyOrgCounts(@Param("year") Integer year,@Param("beginDate") String beginDate);
}
