package com.ruoyi.party.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.Date;

/**
 * 优秀党员对象 excellent_party_member
 * 
 * @author ruoyi
 * @date 2024-05-27
 */
public class ExcellentPartyMember extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 党员列表id */
    @Excel(name = "党员列表id")
    private Long partyMemberId;

    /** 姓名 */
    @Excel(name = "姓名")
    private String xm;

    /** 手机号 */
    @Excel(name = "手机号")
    private String phone;

    /** 所属党组织代码 */
    @Excel(name = "所属党组织代码")
    private String dzzdm;

    /** 年度 */
    @Excel(name = "年度")
    private Integer year;

    /** 有效时间开始 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "有效时间开始", width = 30, dateFormat = "yyyy-MM-dd")
    private Date effectiveTimeStart;

    /** 有效日期结束 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "有效日期结束", width = 30, dateFormat = "yyyy-MM-dd")
    private Date effectiveTimeEnd;

    /** 称号 */
    @Excel(name = "称号")
    private String title;

    /** $column.columnComment */
    @Excel(name = "${comment}", readConverterExp = "$column.readConverterExp()")
    private String careateBy;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setPartyMemberId(Long partyMemberId) 
    {
        this.partyMemberId = partyMemberId;
    }

    public Long getPartyMemberId() 
    {
        return partyMemberId;
    }
    public void setXm(String xm) 
    {
        this.xm = xm;
    }

    public String getXm() 
    {
        return xm;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setDzzdm(String dzzdm) 
    {
        this.dzzdm = dzzdm;
    }

    public String getDzzdm() 
    {
        return dzzdm;
    }
    public void setYear(Integer year) 
    {
        this.year = year;
    }

    public Integer getYear() 
    {
        return year;
    }
    public void setEffectiveTimeStart(Date effectiveTimeStart) 
    {
        this.effectiveTimeStart = effectiveTimeStart;
    }

    public Date getEffectiveTimeStart() 
    {
        return effectiveTimeStart;
    }
    public void setEffectiveTimeEnd(Date effectiveTimeEnd) 
    {
        this.effectiveTimeEnd = effectiveTimeEnd;
    }

    public Date getEffectiveTimeEnd() 
    {
        return effectiveTimeEnd;
    }
    public void setTitle(String title) 
    {
        this.title = title;
    }

    public String getTitle() 
    {
        return title;
    }
    public void setCareateBy(String careateBy) 
    {
        this.careateBy = careateBy;
    }

    public String getCareateBy() 
    {
        return careateBy;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("partyMemberId", getPartyMemberId())
            .append("xm", getXm())
            .append("phone", getPhone())
            .append("dzzdm", getDzzdm())
            .append("year", getYear())
            .append("effectiveTimeStart", getEffectiveTimeStart())
            .append("effectiveTimeEnd", getEffectiveTimeEnd())
            .append("title", getTitle())
            .append("careateBy", getCareateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
