package com.ruoyi.system.service.grid;

import com.ruoyi.system.domain.grid.GridRegion;
import com.ruoyi.system.domain.grid.GridRegionExample;
import com.ruoyi.system.domain.grid.enums.GridRegionSearchParam;
import com.ruoyi.system.service.BaseService;

import java.util.List;
import java.util.Map;

public interface GridRegionService extends BaseService<GridRegion, GridRegionExample> {

    String getWgName(String wgCode);

    String getWgCode(String wgName);

    List<GridRegion> getGridRegionMap();

    Map<String, String> getMapByWgCodes(List<String> wgCodes);

    // 如果是4级地块网格找上一级 否则返回当前层级
    GridRegion getWgOtherCode(String wgCode);

    // 返回所在的2级网格
    GridRegion getSecondWgCode(String wgCode);

    GridRegion loadDetailByCode(String wgCode);

    // 返回子集网格列表
    List<GridRegion> getChildGridRegion(String wgCode);

    GridRegion getWgByCode(String wgCode);

    /**
     * 多个wgCode的like查询
     * @param searchParam
     * @return
     */
    List<GridRegion> getByParams(GridRegionSearchParam searchParam);

}
