package com.ruoyi.system.domain.task.request;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.system.domain.task.TkCommonAssigned;
import com.ruoyi.system.domain.task.vo.UserPojo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import java.util.Date;
import java.util.List;

/**
 * @author vidar
 * date 2024/7/22
 * description
 */
@Data
public class TaskAssignedRequest {
    @NotBlank(message = "id 不能为空")
    @ApiModelProperty("taskId")
    public  String id;
    @ApiModelProperty("抄送人")
    public List<UserPojo> leaders;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date assignedEndTime;
    private String assignedNode;
    /**
     * @see com.ruoyi.system.domain.task.enums.TkPerformUserTypeEnum
     */
    @ApiModelProperty("指派类型 1基础网格 2部门人员")
    private String performUserType;

    @ApiModelProperty("执行人")
    private List<PerformUser> performUserList;

    /**
     * 登录用户信息
     */
    public  String loginUserId;
    public  String loginUserName;
    private String loginUserBelongGrid;

    @Data
    public static class PerformUser{
        private String performUserId;
        private String performUserName;
    }

    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class Assigned extends TkCommonAssigned {
        private static final long serialVersionUID = 985685385453105511L;
        private String performUserGrid;
    }
}
