package com.ruoyi.web.controller.grid;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.service.grid.GridCompanyEconomyService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author : peter
 * @description: TODO
 * @date : 2022-05-10 08:47
 */
@Api(tags = "数据看板 - 企业经济统计")
@RestController
@RequestMapping("/api/grid/company/economy")
public class CompanyEconomyController {

    @Autowired
    private GridCompanyEconomyService gridCompanyEconomyService;

    @PostMapping(value = "import", headers = "content-type=multipart/form-data")
    public AjaxResult importExcel(@RequestParam(value = "file") MultipartFile file,
                                  @RequestParam(value = "belongTime") String belongTime) {
        return gridCompanyEconomyService.importExcel(file, belongTime);
    }

    @GetMapping(value = "/getNowYearCount")
    public AjaxResult getNowYearCount(String wgCode) {
        return AjaxResult.success(gridCompanyEconomyService.getNowYearCount(wgCode));
    }

    @GetMapping(value = "/getMonthCount")
    public AjaxResult getMonthCount(@RequestParam(value = "year") Integer year) {
        return AjaxResult.success(gridCompanyEconomyService.getMonthCount(year));
    }

    @GetMapping(value = "/getTopTenCount")
    public AjaxResult getTopTenCount(String wgCode, String type) {
        return AjaxResult.success(gridCompanyEconomyService.getTopTenCount(wgCode, type));
    }
}
