package com.ruoyi.common.utils.poi;

import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ImportExcelUtil {
	  //获取文件后缀
    public static String getPostFix(String path) {
        if(path == null || "".equals(path.trim())){
            return "";
        }

        if(path.contains(".") && path.lastIndexOf(".") != path.length() -1 ){
            return path.substring(path.lastIndexOf(".") + 1, path.length());
        }

        return "";
    }

    //转换Cell类型的值
    public static String getValue(Cell cell) {
        if (null == cell) {
            return null;
        }
        if (cell.getCellType() == CellType.BOOLEAN){
            return String.valueOf(cell.getBooleanCellValue());
        }
        else if (cell.getCellType() == CellType.NUMERIC) {
        	if(HSSFDateUtil.isCellDateFormatted(cell)){
        		//用于转化为日期格式
        		Date d = cell.getDateCellValue();
        		DateFormat formater = new SimpleDateFormat("yyyy-MM-dd");
        		String t = formater.format(d);
        		return t;
        		}else{
        			DecimalFormat df = new DecimalFormat("0");
        	        return df.format(cell.getNumericCellValue());
        		}
        }
        else{
            return cell.getStringCellValue();
        }
    }
}
