package com.ruoyi.web.controller.operatingmanage;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.annotation.RepeatSubmit;
import com.ruoyi.common.constant.BsConstants;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.ServletUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.domain.operatingmanage.TOperatingmanageNews;
import com.ruoyi.system.service.operatingmanage.TOperatingmanageNewsService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 新闻表
 * @author wujm<wujm@eazytec.com>
 */
@Api(tags = "运营管理-图文资讯")
@RestController
@RequestMapping("/api/operatingmanage/news")
public class TOperatingmanageNewsController extends BaseController {
	
	@Autowired
	private TOperatingmanageNewsService tOperatingmanageNewsService;

	/**
	 * 列表
	 * @param tOperatingmanageNews
	 * @return
	 */
	@GetMapping(value = "/list")
	public TableDataInfo list(TOperatingmanageNews tOperatingmanageNews) {
		startPage();
		if (ServletUtils.getRequest().getRequestURI().contains(BsConstants.REQUEST_SOURCE_MINIAPP)) {
			tOperatingmanageNews.setValid(1);
			return getDataTable(tOperatingmanageNewsService.listTOperatingmanageNews(tOperatingmanageNews));
		}
		tOperatingmanageNews.setCreateBy(getUsername());
		return getDataTable(tOperatingmanageNewsService.listTOperatingmanageNews(tOperatingmanageNews));
	}

	/**
	 * 新增
	 * @param tOperatingmanageNews
	 * @return
	 */
	@Log(title = "新增新闻表", businessType = BusinessType.INSERT)
	@RepeatSubmit
	@PostMapping("/add")
	public AjaxResult save(@RequestBody TOperatingmanageNews tOperatingmanageNews) {
		if (StringUtils.isNull(tOperatingmanageNews.getAttachment()) || tOperatingmanageNews.getAttachment().isEmpty()) {
			throw new ServiceException("缺少附件");
		}
		tOperatingmanageNews.setCreateBy(getUsername());
		return toAjax(tOperatingmanageNewsService.saveTOperatingmanageNews(tOperatingmanageNews));
	}
	
	/**
	 * 根据id查询详情
	 * @param id
	 * @return
	 */
	@GetMapping("/{id}")
	public AjaxResult getById(@PathVariable("id") Long id) {
		TOperatingmanageNews operatingmanageNews = tOperatingmanageNewsService.getTOperatingmanageNewsById(id);
		if(operatingmanageNews != null && StringUtils.isNotBlank(operatingmanageNews.getNewsContent())){
			String content = operatingmanageNews.getNewsContent().replaceAll("<image ", "<img ");
			operatingmanageNews.setNewsContent(content);
		}
		return AjaxResult.success(operatingmanageNews);
	}
	
	/**
	 * 修改
	 * @param tOperatingmanageNews
	 * @return
	 */
	@Log(title = "修改新闻表", businessType = BusinessType.UPDATE)
	@PutMapping("/update")
	public AjaxResult update(@RequestBody TOperatingmanageNews tOperatingmanageNews) {
		if (StringUtils.isNull(tOperatingmanageNews.getAttachment()) || tOperatingmanageNews.getAttachment().isEmpty()) {
			throw new ServiceException("缺少附件");
		}
		return toAjax(tOperatingmanageNewsService.updateTOperatingmanageNews(tOperatingmanageNews));
	}

	/**
	 * 修改基础信息，不处理附件
	 * @param tOperatingmanageNews
	 * @return
	 */
	@Log(title = "修改新闻表", businessType = BusinessType.UPDATE)
	@PutMapping("/update/{id}")
	public AjaxResult basic(@PathVariable("id") Long id,@RequestBody TOperatingmanageNews tOperatingmanageNews) {
		tOperatingmanageNews.setNewsId(id);
		tOperatingmanageNews.setUpdateBy(getUsername());
		return toAjax(tOperatingmanageNewsService.basicTOperatingmanageNews(tOperatingmanageNews));
	}
	
	/**
	 * 删除
	 * @param ids
	 * @return
	 */
	@Log(title = "删除新闻表", businessType = BusinessType.DELETE)
	@DeleteMapping("/delete")
	public AjaxResult batchRemove(@RequestBody Long[] ids) {
		return toAjax(tOperatingmanageNewsService.batchRemove(ids));
	}
	
}
