/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.readline.functions;

import io.termd.core.readline.Function;
import io.termd.core.readline.LineBuffer;
import io.termd.core.readline.Readline;
import io.termd.core.util.LineBufferUtils;
import java.util.List;

public class HistorySearchForward
implements Function {
    @Override
    public String name() {
        return "history-search-forward";
    }

    @Override
    public void apply(Readline.Interaction interaction) {
        LineBuffer buf = interaction.buffer().copy();
        int cursor = buf.getCursor();
        List<int[]> history = interaction.history();
        int currentHistoryIndex = interaction.getHistoryIndex();
        if (currentHistoryIndex == 0 && LineBufferUtils.equals(buf, history.get(currentHistoryIndex))) {
            interaction.refresh(new LineBuffer());
            interaction.setHistoryIndex(-1);
        } else if (currentHistoryIndex > 0 && LineBufferUtils.equals(buf, history.get(currentHistoryIndex)) && cursor == buf.getSize()) {
            interaction.refresh(new LineBuffer().insert(history.get(currentHistoryIndex - 1)));
            interaction.setHistoryIndex(currentHistoryIndex - 1);
        } else {
            int searchStart;
            for (int i = searchStart = currentHistoryIndex - 1; i >= 0; --i) {
                int[] line = history.get(i);
                if (LineBufferUtils.equals(buf, line) || !LineBufferUtils.matchBeforeCursor(buf, line)) continue;
                interaction.refresh(new LineBuffer().insert(line).setCursor(cursor));
                interaction.setHistoryIndex(i);
                break;
            }
        }
        interaction.resume();
    }
}

