package com.ruoyi.web.controller.lawcase;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.zqt.ZQTPageModel;
import com.ruoyi.system.domain.lawcase.CaseLawEnforcement;
import com.ruoyi.system.domain.lawcase.CaseLawEnforcementExample;
import com.ruoyi.system.service.lawcase.CaseLawEnforcementService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @Description : 案件受理登记单
 *
 * @Author : juyx
 * @Date : 2019/8/1
 */
@Api(tags = "综合执法-执法检查")
@RestController
@RequestMapping("/case/law/enforcement")
public class CaseLawEnforcementController {

    @Autowired
    private CaseLawEnforcementService caseLawEnforcementService;

	@ApiOperation("分页")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "pageNum", value = "页码", dataType = "int", paramType = "query"),
			@ApiImplicitParam(name = "pageSize", value = "每页条数", dataType = "int", paramType = "query"),
			@ApiImplicitParam(name = "ylzd5", value = "标题", dataType = "string", paramType = "query"),
			@ApiImplicitParam(name = "ajbm", value = "受理编号", dataType = "string", paramType = "query"),
			@ApiImplicitParam(name = "ajlyLx", value = "案件来源类型", dataType = "string", paramType = "query"),
			@ApiImplicitParam(name = "dsr", value = "当事人", dataType = "string", paramType = "query"),
			@ApiImplicitParam(name = "ajlyMc", value = "受理人", dataType = "string", paramType = "query"),
			@ApiImplicitParam(name = "startDate", value = "受理开始时间", dataType = "date", paramType = "query"),
			@ApiImplicitParam(name = "endDate", value = "受理结束时间", dataType = "date", paramType = "query"),
            @ApiImplicitParam(name = "creditCode", value = "企业信用id", dataType = "date", paramType = "query"),
	})
	@RequestMapping(value = "page", method = RequestMethod.GET)
	@ResponseBody
	public AjaxResult page(@RequestParam(value = "pageNum", defaultValue = "1") Integer pageNum,
			@RequestParam(value = "pageSize", defaultValue = "10") Integer pageSize,
					   String ylzd5, String ajbm, String ajlyLx, String dsr, String ajlyMc, String startDate, String endDate, String creditCode) {
		try {
			if (null == pageNum || pageNum <= 0) {
				pageNum = 1;
			}
			if (null == pageSize || pageSize <= 0) {
				pageSize = 10;
			}
			ZQTPageModel<CaseLawEnforcement> appPageModel = new ZQTPageModel<>();
			appPageModel.setRecordCount(0);
			appPageModel.setPageCount(0);
			appPageModel.setCurPage(pageNum);
			appPageModel.setItemList(new ArrayList<>());

			CaseLawEnforcementExample example = new CaseLawEnforcementExample();
			CaseLawEnforcementExample.Criteria criteria = example.createCriteria();
            criteria.andState7EqualTo("0");
			if (StringUtils.isNotBlank(ajbm)) {
				criteria.andAjbmLike("%" + ajbm + "%");
			}
			if (StringUtils.isNotBlank(ylzd5)) {
				criteria.andYlzd5Like("%" + ylzd5 + "%");
			}
			if (StringUtils.isNotBlank(ajlyLx)) {
				criteria.andAjlyLxEqualTo(ajlyLx);
			}
			if (StringUtils.isNotBlank(dsr)) {
				criteria.andDsrFrMcLike("%" + dsr + "%");
			}
			if (StringUtils.isNotBlank(ajlyMc)) {
				criteria.andCreatorNameLike("%" + ajlyMc + "%");
			}
            if (StringUtils.isNotBlank(creditCode)) {
                criteria.andYlzd4Like("%" + creditCode + "%");
            }
			if (StringUtils.isNotBlank(startDate)) {
				criteria.andSasjGreaterThanOrEqualTo(startDate);
			}
			if (StringUtils.isNotBlank(endDate)) {
				criteria.andSasjLessThanOrEqualTo(endDate);
			}
			example.setOrderByClause(" create_time desc ");
            int count = caseLawEnforcementService.countByExample(example);
			List<CaseLawEnforcement> caseLawEnforcements = caseLawEnforcementService.selectByExampleForStartPage(example, pageNum, pageSize);
            appPageModel.setRecordCount(count);
            appPageModel.setPageCount((long) Math.ceil(1.0 * count / pageSize));
            appPageModel.setCurPage(pageNum);
            appPageModel.setItemList(caseLawEnforcements);
            return AjaxResult.success(appPageModel);
		} catch (Exception e) {
			e.printStackTrace();
			return AjaxResult.error(500, "服务器内部错误");
		}
	}

    @ApiOperation("保存")
	@RequestMapping(value = "save", method = RequestMethod.POST)
	@ResponseBody
	public AjaxResult saveSlAjysd(@RequestBody CaseLawEnforcement body) {
		try {
            body.setState7("0");
			int ret = 0;
			if (StringUtils.isEmpty(body.getId())) {
				SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
				String str = sdf.format(new Date());
				String id = UUID.randomUUID().toString();
				body.setId(id);
				body.setAjbm(String.valueOf(new Date().getTime()));
				body.setCreateTime(str);
				ret = caseLawEnforcementService.insert(body);
			} else {
				CaseLawEnforcementExample example = new CaseLawEnforcementExample();
                CaseLawEnforcementExample.Criteria criteria = example.createCriteria();
				criteria.andIdEqualTo(body.getId());
				ret = caseLawEnforcementService.updateByExampleSelective(body, example);
			}
			if (ret > 0) {
				return AjaxResult.success();
			}
		} catch (Exception e) {
			e.printStackTrace();
            return AjaxResult.error(500, "服务器内部错误");
		}
        return AjaxResult.error(500, "服务器内部错误");
	}

    @ApiOperation("详情")
	@RequestMapping(value = "detail", method = RequestMethod.GET)
	@ResponseBody
	public AjaxResult detail(@RequestParam("id") String id) {
        CaseLawEnforcementExample example = new CaseLawEnforcementExample();
        CaseLawEnforcementExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(id);
        CaseLawEnforcement caseLawEnforcement = caseLawEnforcementService.selectFirstByExample(example);
        return AjaxResult.success(caseLawEnforcement);

	}

    @ApiOperation("删除")
	@RequestMapping(value = "del", method = RequestMethod.GET)
	@ResponseBody
	public AjaxResult del(@RequestParam("id") String id) {
        CaseLawEnforcement ajsldjb = caseLawEnforcementService.selectByPrimaryKey(id);
        ajsldjb.setState7("1");
        caseLawEnforcementService.updateByPrimaryKeySelective(ajsldjb);
		return AjaxResult.success();
	}

}
