package com.ruoyi.system.mapper.grid;

import com.ruoyi.system.domain.grid.GridCompanyEconomyInfo;
import com.ruoyi.system.domain.grid.ext.GridCompanyEcoInfoBean;
import com.ruoyi.system.domain.grid.ext.GridCompanyEconomyInfoExt;
import com.ruoyi.system.domain.grid.ext.GridCompanyEconomyInfoPerMuBean;
import com.ruoyi.system.domain.grid.ext.GridCompanyEconomyInfoSaleBean;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

public interface GridCompanyEconomyInfoExtMapper {

    Map<String, Object> sumSaleAndTaxAndPerMu(@Param("companyIds") List<String> companyIds, @Param("year") String year);

    List<GridCompanyEconomyInfoPerMuBean> countPerMu(@Param("year") String year, @Param("landId") String landId);

    List<GridCompanyEconomyInfoSaleBean> countSale(@Param("year") String year);

    List<GridCompanyEconomyInfoSaleBean> countTax(@Param("year") String year);

    long countCompanyEcoInfoList(@Param("type") String type,
                                 @Param("year") String year,
                                 @Param("searchName") String searchName);

    List<GridCompanyEcoInfoBean> selectCompanyEcoInfoList(@Param("type") String type,
                                                          @Param("year") String year,
                                                          @Param("searchName") String searchName,
                                                          @Param("currIndex") Integer currIndex,
                                                          @Param("pageSize") Integer pageSize);

    long countCompanyAreaInfoList(@Param("searchName") String searchName);

    List<GridCompanyEcoInfoBean> selectCompanyAreaInfoList(@Param("searchName") String searchName,
                                                           @Param("currIndex") Integer currIndex,
                                                           @Param("pageSize") Integer pageSize);


    List<GridCompanyEcoInfoBean> pageInfoList(
            @Param("orderType") String orderType,
            @Param("orderValue") String orderValue,
            @Param("companyKeyword") String companyKeyword,
            @Param("year") String year,
            @Param("qylxCode") String qylxCode,
            @Param("currIndex") Integer currIndex,
            @Param("pageSize") Integer pageSize);

    long countPageNum(
            @Param("companyKeyword") String companyKeyword,
            @Param("year") String year,
            @Param("qylxCode") String qylxCode);
}