package com.ruoyi.web.controller.house;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.grid.GridRegion;
import com.ruoyi.system.domain.house.Contrast;
import com.ruoyi.system.domain.house.vo.HouseResourcePage;
import com.ruoyi.system.mapper.grid.GridRegionMapper;
import com.ruoyi.system.mapper.house.ContrastMapper;
import com.ruoyi.system.mapper.house.HouseResourceMapper;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Objects;

@RestController
@RequestMapping("/api/contrast")
public class ContrastController extends BaseController {

    private final ContrastMapper contrastMapper;

    private final GridRegionMapper gridRegionMapper;

    private final HouseResourceMapper houseResourceMapper;

    public ContrastController(ContrastMapper contrastMapper, GridRegionMapper gridRegionMapper, HouseResourceMapper houseResourceMapper) {
        this.contrastMapper = contrastMapper;
        this.gridRegionMapper = gridRegionMapper;
        this.houseResourceMapper = houseResourceMapper;
    }

    @PutMapping("/start")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult start() {
        List<Contrast> contrasts = contrastMapper.selectAll();
        contrasts.parallelStream().forEach(x -> {
            if (StringUtils.hasText(x.getWgName())) {
                x.setWgName(x.getWgName().replaceAll(" ", ""));
            }
            if (StringUtils.hasText(x.getName())) {
                x.setName(x.getName().replaceAll(" ", ""));
            }
        });
        contrasts.forEach(contrast -> {
            System.out.println("当前id = " + contrast.getId());
            if (!StringUtils.hasText(contrast.getWgName())) {
                setFlag(contrast, "未设置经营主体名称");
            } else if (!StringUtils.hasText(contrast.getName())) {
                setFlag(contrast, "网格错误");
            } else {
                GridRegion gridRegion = gridRegionMapper.selectByWgName(contrast.getWgName());
                if (Objects.isNull(gridRegion)) {
                    setFlag(contrast, "社区错误");
                } else {
                    List<HouseResourcePage> list = houseResourceMapper.selectForContrast(gridRegion.getWgCode(), contrast.getName());
                    if (list.isEmpty()) {
                        setFlag(contrast, "该网格下没有该经营主体");
                    } else if (list.size() > 1) {
                        setFlag(contrast, "该网格下有多个同样名字的经营主体");
                    } else {
                        String flag = "";
                        HouseResourcePage houseResourcePage = list.get(0);
                        if (Objects.isNull(contrast.getPrincipal()) || !houseResourcePage.getPrincipal().equals(contrast.getPrincipal())) {
                            flag = flag += "联系人不一致，";
                        } else if (Objects.isNull(contrast.getPrincipalTel()) || !houseResourcePage.getPrincipalTel().equals(contrast.getPrincipalTel())) {
                            flag = flag += "联系电话不一致，";
                        }
                        setFlag(contrast, flag);
                    }
                }
            }
        });
        System.out.println("处理结束");
        return AjaxResult.success();
    }

    private void setFlag(Contrast contrast, String flag) {
        contrast.setFlag(flag);
        contrastMapper.updateById(contrast);
    }
}
