package com.ruoyi.web.controller.video;


import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.system.domain.video.VideoDeviceChannel;
import com.ruoyi.system.domain.video.ext.ChannelCount;
import com.ruoyi.system.domain.video.ext.ChannelUrlInfo;
import com.ruoyi.system.domain.video.ext.Position;
import com.ruoyi.system.service.video.VideoDeviceChannelService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

@RestController
@RequestMapping("/api/video")
public class IccController extends BaseController {

    @Autowired
    VideoDeviceChannelService videoDeviceChannelService;

    //获取list
    @GetMapping("/list")
    public AjaxResult getList(String name,String type){
        VideoDeviceChannel videoDeviceChannel = new VideoDeviceChannel();
        videoDeviceChannel.setChannelName(name);
        videoDeviceChannel.setType(type);
        List<VideoDeviceChannel> res = videoDeviceChannelService.selectVideoDeviceChannelList(videoDeviceChannel);
        return AjaxResult.success(res);
    }

    //分页获取url与img
    @GetMapping("/url")
    public TableDataInfo getVideoList(String name,String type,String status){
        startPage();
        VideoDeviceChannel videoDeviceChannel = new VideoDeviceChannel();
        videoDeviceChannel.setChannelName(name);
        videoDeviceChannel.setType(type);
        videoDeviceChannel.setStatus(status);
        List<ChannelUrlInfo> res = videoDeviceChannelService.selectChannelList(videoDeviceChannel);
        return getDataTable(res);
    }

    //更改名称与类型
    @PostMapping("/update")
    public AjaxResult updateName(@RequestBody VideoDeviceChannel videoDeviceChannel){
        videoDeviceChannelService.UpdateVideoDeviceChannel(videoDeviceChannel);
        return AjaxResult.success();
    }

    @GetMapping("/count")
    public AjaxResult getVideoCount(String type){
        ChannelCount count = new ChannelCount();
        int online = videoDeviceChannelService.getVideoCount(type);
        int all = videoDeviceChannelService.getCount(type);
        count.setOnline(online);
        count.setOffline(all - online);
        return AjaxResult.success(count);
    }

    @GetMapping("/token")
    public AjaxResult getVideoToken() throws Exception {
        String token = videoDeviceChannelService.getVideoToken();
        return AjaxResult.success(token);
    }

    @PostMapping("/position")
    public AjaxResult getVideoPosition(@RequestBody Position position) {
        List<String> list = Arrays.asList(position.getIds());

        //需要两个数组，index_now记录当前传入数组的channelId在数据库中的position
        //此处为了考虑按照类型分类后产生的不完整排序
        int[] index_now = new int[list.size()];
//        System.out.println(Arrays.toString(index_now));

        for(int i = 0; i < list.size(); i++){
            String channelId = list.get(i);
            int position_now = videoDeviceChannelService.positionById(channelId);
            index_now[i] = position_now;
        }
        Arrays.sort(index_now);
//        System.out.println(Arrays.toString(index_now));

        for(int i = 0;i<list.size();i++){
            videoDeviceChannelService.position(list.get(i),index_now[i]);
        }

        return AjaxResult.success();
    }
}
