package com.ruoyi.web.controller.party;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.party.domain.PartyMemberError;
import com.ruoyi.party.service.api.IPartyMemberErrorService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 党员Controller
 * 
 * @author ruoyi
 * @date 2024-05-21
 */
@Api(tags = "党建-党员")
@RestController
@RequestMapping("/api/party/system/error")
public class PartyMemberErrorController extends BaseController
{
    @Autowired
    private IPartyMemberErrorService partyMemberErrorService;

    /**
     * 查询党员列表
     */
    @PreAuthorize("@ss.hasPermi('system:error:list')")
    @GetMapping("/list")
    public TableDataInfo list(PartyMemberError partyMemberError)
    {
        startPage();
        List<PartyMemberError> list = partyMemberErrorService.selectPartyMemberErrorList(partyMemberError);
        return getDataTable(list);
    }

    /**
     * 导出党员列表
     */
    @PreAuthorize("@ss.hasPermi('system:error:export')")
    @Log(title = "党员", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, PartyMemberError partyMemberError)
    {
        List<PartyMemberError> list = partyMemberErrorService.selectPartyMemberErrorList(partyMemberError);
        ExcelUtil<PartyMemberError> util = new ExcelUtil<PartyMemberError>(PartyMemberError.class);
        util.exportExcel(response, list, "党员数据");
    }

    /**
     * 获取党员详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:error:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(partyMemberErrorService.selectPartyMemberErrorById(id));
    }

    /**
     * 新增党员
     */
    @PreAuthorize("@ss.hasPermi('system:error:add')")
    @Log(title = "党员", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody PartyMemberError partyMemberError)
    {
        return toAjax(partyMemberErrorService.insertPartyMemberError(partyMemberError));
    }

    /**
     * 修改党员
     */
    @PreAuthorize("@ss.hasPermi('system:error:edit')")
    @Log(title = "党员", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody PartyMemberError partyMemberError)
    {
        return toAjax(partyMemberErrorService.updatePartyMemberError(partyMemberError));
    }

    /**
     * 删除党员
     */
    @PreAuthorize("@ss.hasPermi('system:error:remove')")
    @Log(title = "党员", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(partyMemberErrorService.deletePartyMemberErrorByIds(ids));
    }
}
