package com.ruoyi.web.controller.house;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.house.HouseResourceAssociationObject;
import com.ruoyi.system.service.house.HouseResourceAssociationObjectService;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/api/houseAssociationObject")
public class HouseResourceAssociationObjectController {

    private final HouseResourceAssociationObjectService houseResourceAssociationObjectService;

    public HouseResourceAssociationObjectController(HouseResourceAssociationObjectService houseResourceAssociationObjectService) {
        this.houseResourceAssociationObjectService = houseResourceAssociationObjectService;
    }

    @PostMapping
    public AjaxResult insertHouseResourceAssociationObject(@RequestBody HouseResourceAssociationObject houseResourceAssociationObject) {
        houseResourceAssociationObjectService.saveHouseResourceAssociationObject(houseResourceAssociationObject);
        return AjaxResult.success();
    }

    @PutMapping
    public AjaxResult updateHouseResourceAssociationObject(@RequestBody HouseResourceAssociationObject houseResourceAssociationObject) {
        houseResourceAssociationObjectService.updateHouseResourceAssociationObject(houseResourceAssociationObject);
        return AjaxResult.success();
    }

    @DeleteMapping
    public AjaxResult deleteHouseResourceAssociationObjectById(@RequestParam String id) {
        houseResourceAssociationObjectService.deleteHouseResourceAssociationObjectById(id);
        return AjaxResult.success();
    }

    @GetMapping("/detail")
        public AjaxResult getHouseResourceAssociationObjectDetail(@RequestParam String houseResourceId) {
        return AjaxResult.success(houseResourceAssociationObjectService.queryHouseResourceAssociationObjectByHouseResourceIdType(houseResourceId));
    }
}
