package com.ruoyi.web.controller.grid;

import com.github.pagehelper.PageHelper;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.domain.grid.GridPeople;
import com.ruoyi.system.domain.grid.vo.GridPeopleSearchParam;
import com.ruoyi.system.domain.grid.vo.PeopleBindParam;
import com.ruoyi.system.service.grid.GridPeopleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.Arrays;

/**
 * @author : peter
 * @description: TODO
 * @date : 2022-05-03 14:21
 */
@Api(tags = "网格管理 - 人口管理")
@RestController
@RequestMapping("/api/grid/people")
public class PeopleController {

    @Autowired
    private GridPeopleService gridPeopleService;

    @RequestMapping(value = "/page", method = RequestMethod.GET)
    public AjaxResult list(@RequestParam(value = "pageNum", defaultValue = "1") int pageNum,
                           @RequestParam(value = "pageSize", defaultValue = "10") int pageSize,
                           @RequestParam(value = "rklxCode", required = false) String rklxCode,
                           @RequestParam(value = "rkbqCode", required = false) String rkbqCode,
                           @RequestParam(value = "wgCode", required = false) String wgCode,
                           @RequestParam(value = "sex", required = false) String sex,
                           @RequestParam(value = "value", required = false) String value) {
        try {
            GridPeople wsPeople = new GridPeople();
            wsPeople.setRklxCode(rklxCode);
            wsPeople.setRkbqCode(rkbqCode);
            wsPeople.setWgCode(wgCode);
            wsPeople.setSex(sex);
            PageHelper.startPage(pageNum, pageSize);
            return AjaxResult.success(gridPeopleService.page(wsPeople, value));
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error(500, "服务器内部错误");
        }
    }

    /**
     * 保存
     */
    @PostMapping(value = "/add")
    public AjaxResult add(@RequestBody GridPeople wsPeople) {
        return gridPeopleService.add(wsPeople);
    }

    /**
     * 修改
     */
    @PostMapping(value = "/edit")
    public AjaxResult edit(@RequestBody GridPeople wsPeople) {
        return gridPeopleService.edit(wsPeople);
    }

    /**
     * 详情
     */
    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") String id) {
        return gridPeopleService.detail(id);
    }

    /**
     * 通过id删除
     */
    @GetMapping(value = "/delete")
    public AjaxResult delete(@RequestParam(value = "id") String id) {
        return gridPeopleService.delete(id);
    }

    /**
     * 通过身份证查询详情
     */
    @GetMapping(value = "/detailByIdCard")
    public AjaxResult detailByIdCard(@RequestParam(value = "idCard") String idCard) {
        return gridPeopleService.detailByIdCard(idCard);
    }

    /**
     * 人口关联房屋信息
     */
    @GetMapping(value = "/peopleToHousePage")
    public AjaxResult peopleToHousePage(@RequestParam(value = "pageNum", defaultValue = "1") int pageNum,
                                        @RequestParam(value = "pageSize", defaultValue = "10") int pageSize,
                                        @RequestParam(value = "peopleId") String peopleId) {
        return gridPeopleService.peopleToHousePage(peopleId, pageNum, pageSize);
    }

    /**
     * 人口关联企业信息
     */
    @GetMapping(value = "/peopleToCompanyPage")
    public AjaxResult peopleToCompanyPage(@RequestParam(value = "pageNum", defaultValue = "1") int pageNum,
                                          @RequestParam(value = "pageSize", defaultValue = "10") int pageSize,
                                          @RequestParam(value = "peopleId") String peopleId) {
        return gridPeopleService.peopleToCompanyPage(peopleId, pageNum, pageSize);
    }

    /**
     * 人口关联商铺信息
     */
    @GetMapping(value = "/peopleToShopPage")
    public AjaxResult peopleToShopPage(@RequestParam(value = "pageNum", defaultValue = "1") int pageNum,
                                       @RequestParam(value = "pageSize", defaultValue = "10") int pageSize,
                                       @RequestParam(value = "peopleId") String peopleId) {
        return gridPeopleService.peopleToShopPage(peopleId, pageNum, pageSize);
    }

    /**
     * @param pageNum
     * @param pageSize
     * @param peopleId
     * @param type     1-住宅 2-企业 3-商铺
     * @return
     */
    @GetMapping(value = "/peopleInfoPage")
    public AjaxResult peopleInfoPage(@RequestParam(value = "pageNum", defaultValue = "1") int pageNum,
                                     @RequestParam(value = "pageSize", defaultValue = "10") int pageSize,
                                     @RequestParam(value = "peopleId") String peopleId,
                                     @RequestParam(value = "type") String type) {
        if ("1".equals(type)) {
            return gridPeopleService.peopleToHousePage(peopleId, pageNum, pageSize);
        } else if ("2".equals(type)) {
            return gridPeopleService.peopleToCompanyPage(peopleId, pageNum, pageSize);
        } else if ("3".equals(type)) {
            return gridPeopleService.peopleToShopPage(peopleId, pageNum, pageSize);
        } else {
            return AjaxResult.success(null);
        }
    }

    /**
     * 人口绑定关系
     */
    @PostMapping(value = "/peopleBind")
    public AjaxResult peopleBind(@RequestBody PeopleBindParam peopleBindParam) {
        return gridPeopleService.peopleBind(peopleBindParam);
    }

    /**
     * 人口信息excel导入
     */
    @PostMapping(value = "import", headers = "content-type=multipart/form-data")
    public AjaxResult importExcel(@RequestParam(value = "file") MultipartFile file,
                                  @RequestParam(value = "createId") String createId) {
        return gridPeopleService.importExcel(file, createId);
    }

    @ApiOperation("所有人口列表")
    @GetMapping("/allPeopleList")
    public AjaxResult getPeopleList(@RequestParam(value = "wgCode")String wgCode){
        GridPeopleSearchParam param = new GridPeopleSearchParam();
        if(StringUtils.isNotBlank(wgCode)){
            param.setWgCodeLikes(Arrays.asList(wgCode.split(",")));
        }
        return AjaxResult.success(gridPeopleService.getAllPeople(param));
    }

}
