package com.ruoyi.web.controller.zb;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.quartz.task.DutyWorkTask;
import com.ruoyi.system.domain.zb.ZbDutyWorkRecord;
import com.ruoyi.system.domain.zb.vo.DutyWorkConfigVO;
import com.ruoyi.system.service.zb.DutyWorkService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * * Author: brenda
 * * 2025/1/21
 **/
@Api(tags = "值班")
@RestController
@RequestMapping("/api/zb/duty")
public class DutyWorkController extends BaseController {

    @Autowired
    private DutyWorkService dutyWorkService;

    @PostMapping("/save")
    public AjaxResult save(@RequestBody DutyWorkConfigVO request){
        SysUser sysUser = getLoginUser().getUser();
        request.setCreateUser(sysUser.getUserId());
        request.setCreateUserName(sysUser.getNickName());
        dutyWorkService.save(request);
        return AjaxResult.success();
    }

    @PostMapping("/update")
    public AjaxResult update(@RequestBody DutyWorkConfigVO request){
        SysUser sysUser = getLoginUser().getUser();
        request.setCreateUser(sysUser.getUserId());
        request.setCreateUserName(sysUser.getNickName());
        dutyWorkService.update(request);
        return AjaxResult.success();
    }

    @GetMapping("/page")
    public AjaxResult dutyPage(@RequestParam("pageNum") int pageNum, @RequestParam("pageSize") int pageSize,
                               @RequestParam(value = "title", required = false)String title){
        PageHelper.startPage(pageNum, pageSize);
        PageInfo<ZbDutyWorkRecord> pageInfo = dutyWorkService.dutyRecordPage(title);
        return AjaxResult.success(pageInfo);
    }

    /**
     * 计划配置详情
     * @return
     */
    @GetMapping("/config/detail")
    public AjaxResult detail(){
        return AjaxResult.success(dutyWorkService.configDetail());
    }

    /**
     * 已发布的计划详情
     * @param id
     * @return
     */
    @GetMapping("/detail/{id}")
    public AjaxResult detail(@PathVariable("id") String id){
        return AjaxResult.success(dutyWorkService.dutyWorkDetail(id));
    }

}
