/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bytekit.asm.location.filter;

import com.alibaba.bytekit.asm.location.LocationType;
import com.alibaba.bytekit.asm.location.filter.LocationFilter;
import com.alibaba.deps.org.objectweb.asm.tree.AbstractInsnNode;
import com.alibaba.deps.org.objectweb.asm.tree.MethodInsnNode;

public class InvokeContainLocationFilter
implements LocationFilter {
    private String owner;
    private String methodName;
    private LocationType locationType;

    public InvokeContainLocationFilter(String owner, String methodName, LocationType locationType) {
        this.owner = owner;
        this.methodName = methodName;
        this.locationType = locationType;
    }

    @Override
    public boolean allow(AbstractInsnNode insnNode, LocationType locationType, boolean complete) {
        if (!this.locationType.equals((Object)locationType)) {
            return false;
        }
        MethodInsnNode methodInsnNode = this.findMethodInsnNode(insnNode);
        return methodInsnNode == null || !methodInsnNode.owner.equals(this.owner) || !methodInsnNode.name.equals(this.methodName);
    }

    private MethodInsnNode findMethodInsnNode(AbstractInsnNode insnNode) {
        MethodInsnNode methodInsnNode;
        AbstractInsnNode current = insnNode;
        while (current != null) {
            if (!((current = current.getNext()) instanceof MethodInsnNode)) continue;
            methodInsnNode = (MethodInsnNode)current;
            if (!methodInsnNode.owner.equals(this.owner) || !methodInsnNode.name.equals(this.methodName)) continue;
            return methodInsnNode;
        }
        current = insnNode;
        while (current != null) {
            if (!((current = current.getPrevious()) instanceof MethodInsnNode)) continue;
            methodInsnNode = (MethodInsnNode)current;
            if (!methodInsnNode.owner.equals(this.owner) || !methodInsnNode.name.equals(this.methodName)) continue;
            return methodInsnNode;
        }
        return null;
    }
}

