/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.text;

import com.taobao.text.CLS;
import com.taobao.text.LineRenderer;
import com.taobao.text.RenderAppendable;
import com.taobao.text.Renderer;
import com.taobao.text.ScreenContext;
import com.taobao.text.Style;
import com.taobao.text.stream.Consumer;
import java.io.IOException;
import java.util.LinkedList;

public class ScreenContextConsumer
implements Consumer<Object> {
    private final LinkedList<Object> buffer = new LinkedList();
    private Renderer renderable = null;
    private final RenderAppendable out;

    public ScreenContextConsumer(ScreenContext out) {
        this.out = new RenderAppendable(out);
    }

    @Override
    public Class<Object> getConsumedType() {
        return Object.class;
    }

    @Override
    public void provide(Object element) throws IOException {
        Renderer<?> current = Renderer.getRenderable(element.getClass());
        if (current == null) {
            this.send();
            if (element instanceof CharSequence) {
                this.out.append((CharSequence)element);
            } else if (element instanceof CLS) {
                this.out.cls();
            } else if (element instanceof Style) {
                this.out.append((Style)element);
            } else {
                this.out.append(element.toString());
            }
        } else {
            if (this.renderable != null && !current.equals(this.renderable)) {
                this.send();
            }
            this.buffer.addLast(element);
            this.renderable = current;
        }
    }

    @Override
    public void flush() throws IOException {
        this.send();
        this.out.flush();
    }

    public void send() throws IOException {
        if (this.buffer.size() > 0) {
            LineRenderer renderer = this.renderable.renderer(this.buffer.iterator());
            renderer.render(this.out);
            this.buffer.clear();
            this.renderable = null;
        }
    }
}

