package com.ruoyi.system.service.other.impl;

import com.ruoyi.system.domain.other.Labels;
import com.ruoyi.system.domain.other.LabelsExample;
import com.ruoyi.system.listener.MyBaseService;
import com.ruoyi.system.mapper.other.LabelsMapper;
import com.ruoyi.system.service.BaseServiceImpl;
import com.ruoyi.system.service.other.LabelsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author Cesar
 * @date ${cTime}
 * @desc BsCommonService实现
 */
@Service
@MyBaseService
public class LabelsServiceImpl extends BaseServiceImpl<LabelsMapper, Labels, LabelsExample> implements LabelsService {

    private static final Logger LOGGER = LoggerFactory.getLogger(LabelsServiceImpl.class);

    @Autowired
    private LabelsMapper bsCommonMapper;

    @Override
    public List<Labels> getWgdxList(String code) {
        return bsCommonMapper.getWgdxList(code);
    }

    @Override
    public String getName(String code) {
        LabelsExample ex = new LabelsExample();
        LabelsExample.Criteria ca = ex.createCriteria();
        ca.andCodeEqualTo(code);
        ca.andIsValidEqualTo("1");
        Labels bsCommon = selectFirstByExample(ex);
        if (bsCommon != null) {
            return bsCommon.getName();
        } else {
            return null;
        }
    }

    @Override
    public String getCode(String name) {
        LabelsExample ex = new LabelsExample();
        LabelsExample.Criteria ca = ex.createCriteria();
        ca.andNameEqualTo(name);
        ca.andIsValidEqualTo("1");
        Labels bsCommon = selectFirstByExample(ex);
        if (bsCommon != null) {
            return bsCommon.getCode();
        } else {
            return null;
        }
    }

    @Override
    public List<Labels> getBsCommonMap() {
        LabelsExample ex = new LabelsExample();
        LabelsExample.Criteria ca = ex.createCriteria();
        ca.andIsValidEqualTo("1");
        return this.selectByExample(ex);
    }

    @Override
    public Map<String, String> getMapByCodes(List<String> codes) {
        LabelsExample ex = new LabelsExample();
        LabelsExample.Criteria ca = ex.createCriteria();
        ca.andIsValidEqualTo("1");
        ca.andCodeIn(codes);
        List<Labels> commonList = bsCommonMapper.selectByExample(ex);
        return commonList.stream().collect(Collectors.toMap(Labels::getCode, Labels::getName));
    }
}
