package com.ruoyi.web.controller.other;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.system.domain.other.MapEntity;
import com.ruoyi.system.service.other.MapEntityService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/map")
@Api(tags = "地图")
public class MapEntityController extends BaseController {

    @Autowired
    private MapEntityService mapEntityService;

    @RequestMapping(value = "/getAllMapEntities",method = RequestMethod.GET)
    @ResponseBody
    public List<MapEntity> getAllMapEntities() {
        return mapEntityService.getAllMapEntities();
    }

    @RequestMapping(value = "/getMapEntityById",method = RequestMethod.GET)
    @ResponseBody
    public MapEntity getMapEntityById(@RequestParam(name = "id") String id) {
        return mapEntityService.getMapEntityById(id);
    }

    @RequestMapping(value = "/addMapEntity",method = RequestMethod.POST)
    @ResponseBody
    public MapEntity addMapEntityById(@RequestBody MapEntity mapEntity) {
        return mapEntityService.addMapEntityById(mapEntity);
    }

    @RequestMapping(value = "/updateMapEntity",method = RequestMethod.POST)
    @ResponseBody
    public MapEntity updateMapEntity(@RequestBody MapEntity mapEntity) {
        return mapEntityService.updateMapEntity(mapEntity.getId(), mapEntity);
    }

    @RequestMapping(value = "/deleteMapEntity",method = RequestMethod.DELETE)
    @ResponseBody
    public void deleteMapEntity(@RequestParam(name = "id") String id) {
        mapEntityService.deleteMapEntity(id);
    }
}
