package com.ruoyi.system.service.grid;

import com.ruoyi.system.domain.grid.GridWorkReport;
import com.ruoyi.system.domain.grid.GridWorkReportExample;
import com.ruoyi.system.service.BaseService;

import java.util.List;

/**
 * @author condey
 * @version $$package: com.ruoyi.system.service.grid, v 0.1 2024/6/24 4:32 PM condey Exp $$
 */
public interface GridWorkReportService extends BaseService<GridWorkReport, GridWorkReportExample> {

    /**
     * 创建report, 如果年月日有重复， 则重新生成
     *
     * @param report
     * @return
     */
    Long createReport(GridWorkReport report);


    /**
     * 查询列表
     *
     * @param year
     * @param month
     * @return
     */
    List<GridWorkReport> queryList(String year, String month);


    /**
     * 加载详情
     *
     * @param id
     * @return
     */
    GridWorkReport detail(Long id);
}
