package com.ruoyi.party.mapper;

import com.ruoyi.party.domain.ClickNumber;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 点击次数Mapper接口
 * 
 * @author ruoyi
 * @date 2024-05-24
 */
public interface ClickNumberMapper 
{
    /**
     * 查询点击次数
     * 
     * @param id 点击次数主键
     * @return 点击次数
     */
    public ClickNumber selectClickNumberById(Long id);

    /**
     * 查询点击次数列表
     * 
     * @param clickNumber 点击次数
     * @return 点击次数集合
     */
    public List<ClickNumber> selectClickNumberList(ClickNumber clickNumber);

    /**
     * 新增点击次数
     * 
     * @param clickNumber 点击次数
     * @return 结果
     */
    public int insertClickNumber(ClickNumber clickNumber);

    /**
     * 修改点击次数
     * 
     * @param clickNumber 点击次数
     * @return 结果
     */
    public int updateClickNumber(ClickNumber clickNumber);

    /**
     * 删除点击次数
     * 
     * @param id 点击次数主键
     * @return 结果
     */
    public int deleteClickNumberById(Long id);

    /**
     * 批量删除点击次数
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteClickNumberByIds(Long[] ids);


    long selectClickNumberStatisticsByTypeBusinessKey(@Param("type") String type, @Param("businessKey") String businessKey);
}
