package com.ruoyi.web.controller.stamp;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysDept;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.system.domain.stamp.request.CarDinnerExamineRequest;
import com.ruoyi.system.domain.stamp.request.CarExamineSaveRequest;
import com.ruoyi.system.domain.stamp.vo.CarExaminePageItem;
import com.ruoyi.system.service.stamp.CarExamineService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Date;

/**
 * * Author: brenda
 * * 2025/2/8
 **/
@Api(tags = "用车申请")
@RestController
@RequestMapping("/api/car/examine")
public class CarExamineController extends BaseController {

    @Autowired
    private CarExamineService carExamineService;

    @PostMapping("/save")
    public AjaxResult save(@RequestBody CarExamineSaveRequest request){
        SysUser sysUser = getLoginUser().getUser();
        request.setCreateUser(sysUser.getUserId());
        request.setCreateTime(new Date());
        request.setCreateUserName(sysUser.getNickName());
        SysDept sysDept = sysUser.getDept();
        if(sysDept != null){
            request.setDepId(sysDept.getDeptId());
            request.setDepName(sysDept.getDeptName());
        }
        carExamineService.save(request);
        return AjaxResult.success();
    }

    /**
     * 审批
     * 审批通过 F， 审批退回 B
     * @return
     */
    @PostMapping("/examine")
    public AjaxResult examine(@RequestBody CarDinnerExamineRequest request){
        request.setUserId(getUserId());
        carExamineService.apply(request);
        return AjaxResult.success();
    }

    @GetMapping("/detail/{id}")
    public AjaxResult detail(@PathVariable("id")String id){
        return AjaxResult.success(carExamineService.detail(id, getUserId()));
    }

    @GetMapping("/page")
    public AjaxResult page(@RequestParam("pageNum") int pageNum, @RequestParam("pageSize") int pageSize,
                           @RequestParam(value = "title", required = false)String title,
                           @RequestParam(value = "status", required = false)String status){
        PageHelper.startPage(pageNum, pageSize);
        PageInfo<CarExaminePageItem> pageInfo = carExamineService.page(title, status, getUserId());
        return AjaxResult.success(pageInfo);
    }

    /**
     * 重新提交
     * @param request
     * @return
     */
    @PostMapping("/reSubmit")
    public AjaxResult reSubmit(@RequestBody CarExamineSaveRequest request){
        SysUser sysUser = getLoginUser().getUser();
        request.setCreateUser(sysUser.getUserId());
        request.setCreateTime(new Date());
        request.setCreateUserName(sysUser.getNickName());
        request.setUpdateTime(new Date());
        SysDept sysDept = sysUser.getDept();
        if(sysDept != null){
            request.setDepId(sysDept.getDeptId());
            request.setDepName(sysDept.getDeptName());
        }
        carExamineService.reSubmit(request);
        return AjaxResult.success();
    }
}
