package com.ruoyi.web.controller.operatingmanage;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.operatingmanage.vo.WsImportantNewsExt;
import com.ruoyi.system.service.operatingmanage.WsImportantNewsService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@Api(tags = "运营管理-视频要闻")
@RestController
@RequestMapping("/api/operatingmanage/importantNews")
public class ImportantNewsController {

    @Autowired
    WsImportantNewsService wsImportantNewsService;

    /**
     * 保存
     */
    @PostMapping(value = "/add")
    public AjaxResult add(@RequestBody WsImportantNewsExt wsImportantNews) throws Exception {
        wsImportantNewsService.addWsImportantNews(wsImportantNews);
        return AjaxResult.success();
    }

    /**
     * 更新
     */
    @PutMapping(value = "/update")
    public AjaxResult update(@RequestBody WsImportantNewsExt wsImportantNews) throws Exception {
        wsImportantNewsService.updateWsImportantNews(wsImportantNews);
        return AjaxResult.success();
    }

    /**
     * 删除
     */
    @DeleteMapping(value = "/delete")
    public AjaxResult batchRemove(@RequestBody Long[] ids){
        wsImportantNewsService.batchRemove(ids);
        return AjaxResult.success();
    }


    /**
     * 列表
     */
    @GetMapping(value = "/ListImportantNews")
    public AjaxResult ListWsPeople(@RequestParam(value = "pageNum", defaultValue = "1") int pageNum,
                                   @RequestParam(value = "pageSize", defaultValue = "10") int pageSize,
                                   @RequestParam(value = "newsName",required = false) String newsName,
                                   @RequestParam(value = "valid",required = false) String valid
    ) {
        WsImportantNewsExt importantNews = new WsImportantNewsExt();
        importantNews.setPageNum(pageNum);
        importantNews.setPageSize(pageSize);
        importantNews.setNewsName(newsName);
        if(null != valid){
            importantNews.setValid(Byte.valueOf(valid));
        }
        return AjaxResult.success(wsImportantNewsService.ListWsImportantNews(importantNews));
    }

    /**
     * 单独查询详情
     * @param id
     * @return
     * @throws Exception
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getById(@PathVariable("id") Long id) {
        return AjaxResult.success(wsImportantNewsService.getWsImportantNewsById(id));
    }
}
