package com.ruoyi.system.service.grid.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.system.domain.grid.GridWgNotice;
import com.ruoyi.system.mapper.grid.GridWgNoticeMapper;
import com.ruoyi.system.service.grid.GridWgNoticeService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

/**
 * 网格公告
 *
 * @author wujm<wujm @ eazytec.com>
 */
@Service
public class GridWgNoticeServiceImpl implements GridWgNoticeService {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Resource
    private GridWgNoticeMapper gridWgNoticeMapper;


    /** 基础功能不要直接写实现 */
    /**
     * 列表
     *
     * @return
     */
    private List<GridWgNotice> list(GridWgNotice gridWgNotice) {

        LambdaQueryWrapper<GridWgNotice> qw = new LambdaQueryWrapper<>();
        if (gridWgNotice != null) {

            if (StringUtils.isNotBlank(gridWgNotice.getNoticeSource())) {
                qw.eq(GridWgNotice::getNoticeSource, gridWgNotice.getNoticeSource());
            }
            if(StringUtils.isNotBlank(gridWgNotice.getNoticeTitle())){
                qw.like(GridWgNotice::getNoticeTitle, gridWgNotice.getNoticeTitle());
            }
            if(gridWgNotice.getValid() != null){
                qw.eq(GridWgNotice::getValid, gridWgNotice.getValid());
            }
        }
        return gridWgNoticeMapper.selectList(qw);
    }

    /**
     * 查询
     *
     * @param id
     */
    private GridWgNotice getObjectById(Long id) {
        return gridWgNoticeMapper.selectById(id);
    }

    /**
     * 分页查询
     *
     * @param gridWgNotice
     * @return
     */
    @Override
    public List<GridWgNotice> listGridWgNotice(GridWgNotice gridWgNotice) {
        return this.list(gridWgNotice);
    }

    /**
     * 新增
     *
     * @param gridWgNotice
     * @return
     */
    @Override
    public int saveGridWgNotice(GridWgNotice gridWgNotice) {
        return gridWgNoticeMapper.insert(gridWgNotice);
    }

    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    @Override
    public GridWgNotice getGridWgNoticeById(Long id) {
        return this.getObjectById(id);
    }

    /**
     * 修改
     *
     * @param gridWgNotice
     * @return
     */
    @Override
    public int updateGridWgNotice(GridWgNotice gridWgNotice) {
        return gridWgNoticeMapper.updateById(gridWgNotice);
    }

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @Override
    public int batchRemove(Long[] ids) {
        return gridWgNoticeMapper.deleteBatchIds(Arrays.asList(ids));
    }

}
