package com.ruoyi.system.service.form;


import com.ruoyi.system.domain.form.MdForm;
import com.ruoyi.system.domain.form.MdFormCategory;
import com.ruoyi.system.domain.form.MdFormCategoryExample;
import com.ruoyi.system.domain.form.MdFormExample;
import com.ruoyi.system.domain.form.params.FormQuery;
import com.ruoyi.system.domain.form.vo.MdFormCategoryVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;


@Service
public class FormCategoryManager {

    @Autowired
    private MdFormCategoryService mdFormCategoryService;
    @Autowired
    private MdFormService formService;

    @Autowired
    private FormManager formManager;

    public List<MdFormCategoryVo> query(FormQuery query) {
        MdFormCategoryExample example3 = new MdFormCategoryExample();
        MdFormCategoryExample.Criteria c0 = example3.createCriteria();
        c0.andStatusEqualTo(1);

        example3.setOrderByClause("create_time desc");
        List<MdFormCategory> list = mdFormCategoryService.selectByExample(example3);
        if (list == null || list.isEmpty()) return null;
        List<MdFormCategoryVo> list2 = new ArrayList<>();
        for (MdFormCategory mdFormCategory : list) {
            query.setCategoryId(mdFormCategory.getId());
            query.setUserId(query.getOwnUser());
            query.setIsMasterAdmin(query.getOwnMasterAdmin());
            List<MdForm> mdFormList = formManager.query(query);
            MdFormCategoryVo mdFormCategoryVo = new MdFormCategoryVo();
            BeanUtils.copyProperties(mdFormCategory, mdFormCategoryVo);
            mdFormCategoryVo.setCount(mdFormList.size());
            list2.add(mdFormCategoryVo);
        }
        return list2;
    }


    public String saveOrUpdate(MdFormCategory mdFormCategory) {
        mdFormCategory.setCreateTime(System.currentTimeMillis());
        mdFormCategory.setStatus(1);
        int count;

        //用于判定name是否重复。
        MdFormCategoryExample example = new MdFormCategoryExample();
        MdFormCategoryExample.Criteria c = example.createCriteria();
        c.andNameEqualTo(mdFormCategory.getName()).andStatusEqualTo(1);

        //新增
        if (StringUtils.isEmpty(mdFormCategory.getId())) {
            int _count = mdFormCategoryService.countByExample(example);
            if (_count > 0) throw new RuntimeException("名称已存在，请更改！");


            mdFormCategory.setId(UUID.randomUUID().toString());
            count = mdFormCategoryService.insert(mdFormCategory);
        } else {
            c.andIdNotEqualTo(mdFormCategory.getId());
            int _count = mdFormCategoryService.countByExample(example);
            if (_count > 0) throw new RuntimeException("名称已存在，请更改！");


            //更新
            count = mdFormCategoryService.updateByPrimaryKeySelective(mdFormCategory);
        }

        if (count > 0) {
            return mdFormCategory.getId();
        }

        throw new RuntimeException("保存失败");
    }

    public int deleteById(MdFormCategory mdFormCategory) {
        mdFormCategory.setStatus(0);
        int count = mdFormCategoryService.updateByPrimaryKeySelective(mdFormCategory);

        if (count > 0) {

            MdFormExample example2 = new MdFormExample();
            example2.createCriteria().andCategoryIdEqualTo(mdFormCategory.getId());
            MdForm mdForm = new MdForm();
            mdForm.setCategoryId("");
            formService.updateByExampleSelective(mdForm, example2);

        }
        return count;
    }

    public List<MdFormCategory> categoryList(){
        MdFormCategoryExample example3 = new MdFormCategoryExample();
        MdFormCategoryExample.Criteria c0 = example3.createCriteria();
        c0.andStatusEqualTo(1);

        example3.setOrderByClause("create_time desc");
        return mdFormCategoryService.selectByExample(example3);
    }
}
