/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.klass100;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.core.command.model.ClassDetailVO;
import com.taobao.arthas.core.command.model.ClassLoaderModel;
import com.taobao.arthas.core.command.model.ClassLoaderVO;
import com.taobao.arthas.core.command.model.ClassSetVO;
import com.taobao.arthas.core.command.model.MessageModel;
import com.taobao.arthas.core.command.model.RowAffectModel;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.shell.handlers.Handler;
import com.taobao.arthas.core.util.ClassLoaderUtils;
import com.taobao.arthas.core.util.ClassUtils;
import com.taobao.arthas.core.util.ResultUtils;
import com.taobao.arthas.core.util.affect.RowAffect;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

@Name(value="classloader")
@Summary(value="Show classloader info")
@Description(value="\nEXAMPLES:\n  classloader\n  classloader -t\n  classloader -l\n  classloader -c 327a647b\n  classloader -c 327a647b -r META-INF/MANIFEST.MF\n  classloader -a\n  classloader -a -c 327a647b\n  classloader -c 659e0bfd --load demo.MathGame\n\nWIKI:\n  https://arthas.aliyun.com/doc/classloader")
public class ClassLoaderCommand
extends AnnotatedCommand {
    private Logger logger = LoggerFactory.getLogger(ClassLoaderCommand.class);
    private boolean isTree = false;
    private String hashCode;
    private String classLoaderClass;
    private boolean all = false;
    private String resource;
    private boolean includeReflectionClassLoader = true;
    private boolean listClassLoader = false;
    private String loadClass = null;
    private volatile boolean isInterrupted = false;

    @Option(shortName="t", longName="tree", flag=true)
    @Description(value="Display ClassLoader tree")
    public void setTree(boolean tree) {
        this.isTree = tree;
    }

    @Option(longName="classLoaderClass")
    @Description(value="The class name of the special class's classLoader.")
    public void setClassLoaderClass(String classLoaderClass) {
        this.classLoaderClass = classLoaderClass;
    }

    @Option(shortName="c", longName="classloader")
    @Description(value="The hash code of the special ClassLoader")
    public void setHashCode(String hashCode) {
        this.hashCode = hashCode;
    }

    @Option(shortName="a", longName="all", flag=true)
    @Description(value="Display all classes loaded by ClassLoader")
    public void setAll(boolean all) {
        this.all = all;
    }

    @Option(shortName="r", longName="resource")
    @Description(value="Use ClassLoader to find resources, won't work without -c specified")
    public void setResource(String resource) {
        this.resource = resource;
    }

    @Option(shortName="i", longName="include-reflection-classloader", flag=true)
    @Description(value="Include sun.reflect.DelegatingClassLoader")
    public void setIncludeReflectionClassLoader(boolean includeReflectionClassLoader) {
        this.includeReflectionClassLoader = includeReflectionClassLoader;
    }

    @Option(shortName="l", longName="list-classloader", flag=true)
    @Description(value="Display statistics info by classloader instance")
    public void setListClassLoader(boolean listClassLoader) {
        this.listClassLoader = listClassLoader;
    }

    @Option(longName="load")
    @Description(value="Use ClassLoader to load class, won't work without -c specified")
    public void setLoadClass(String className) {
        this.loadClass = className;
    }

    @Override
    public void process(CommandProcess process) {
        process.interruptHandler(new ClassLoaderInterruptHandler(this));
        ClassLoader targetClassLoader = null;
        boolean classLoaderSpecified = false;
        Instrumentation inst = process.session().getInstrumentation();
        if (this.hashCode != null || this.classLoaderClass != null) {
            classLoaderSpecified = true;
        }
        if (this.hashCode != null) {
            Set<ClassLoader> allClassLoader = ClassLoaderCommand.getAllClassLoaders(inst, new Filter[0]);
            for (ClassLoader cl : allClassLoader) {
                if (!Integer.toHexString(cl.hashCode()).equals(this.hashCode)) continue;
                targetClassLoader = cl;
                break;
            }
        } else if (this.classLoaderClass != null) {
            List<ClassLoader> matchedClassLoaders = ClassLoaderUtils.getClassLoaderByClassName(inst, this.classLoaderClass);
            if (matchedClassLoaders.size() == 1) {
                targetClassLoader = matchedClassLoaders.get(0);
            } else {
                if (matchedClassLoaders.size() > 1) {
                    List<ClassLoaderVO> classLoaderVOList = ClassUtils.createClassLoaderVOList(matchedClassLoaders);
                    ClassLoaderModel classloaderModel = new ClassLoaderModel().setClassLoaderClass(this.classLoaderClass).setMatchedClassLoaders(classLoaderVOList);
                    process.appendResult(classloaderModel);
                    process.end(-1, "Found more than one classloader by class name, please specify classloader with '-c <classloader hash>'");
                    return;
                }
                process.end(-1, "Can not find classloader by class name: " + this.classLoaderClass + ".");
                return;
            }
        }
        if (this.all) {
            this.processAllClasses(process, inst);
        } else if (classLoaderSpecified && this.resource != null) {
            this.processResources(process, inst, targetClassLoader);
        } else if (classLoaderSpecified && this.loadClass != null) {
            this.processLoadClass(process, inst, targetClassLoader);
        } else if (classLoaderSpecified) {
            this.processClassLoader(process, inst, targetClassLoader);
        } else if (this.listClassLoader || this.isTree) {
            this.processClassLoaders(process, inst);
        } else {
            this.processClassLoaderStats(process, inst);
        }
    }

    private void processClassLoaderStats(CommandProcess process, Instrumentation inst) {
        RowAffect affect = new RowAffect();
        List<ClassLoaderInfo> classLoaderInfos = ClassLoaderCommand.getAllClassLoaderInfo(inst, new Filter[0]);
        HashMap<String, ClassLoaderStat> classLoaderStats = new HashMap<String, ClassLoaderStat>();
        for (ClassLoaderInfo info : classLoaderInfos) {
            String name = info.classLoader == null ? "BootstrapClassLoader" : info.classLoader.getClass().getName();
            ClassLoaderStat stat = (ClassLoaderStat)classLoaderStats.get(name);
            if (null == stat) {
                stat = new ClassLoaderStat();
                classLoaderStats.put(name, stat);
            }
            stat.addLoadedCount(info.loadedClassCount);
            stat.addNumberOfInstance(1);
        }
        TreeMap<String, ClassLoaderStat> sorted = new TreeMap<String, ClassLoaderStat>(new ValueComparator(classLoaderStats));
        sorted.putAll(classLoaderStats);
        process.appendResult(new ClassLoaderModel().setClassLoaderStats(sorted));
        affect.rCnt(sorted.keySet().size());
        process.appendResult(new RowAffectModel(affect));
        process.end();
    }

    private void processClassLoaders(CommandProcess process, Instrumentation inst) {
        RowAffect affect = new RowAffect();
        List<ClassLoaderInfo> classLoaderInfos = this.includeReflectionClassLoader ? ClassLoaderCommand.getAllClassLoaderInfo(inst, new Filter[0]) : ClassLoaderCommand.getAllClassLoaderInfo(inst, new SunReflectionClassLoaderFilter());
        List<ClassLoaderVO> classLoaderVOs = new ArrayList<ClassLoaderVO>(classLoaderInfos.size());
        for (ClassLoaderInfo classLoaderInfo : classLoaderInfos) {
            ClassLoaderVO classLoaderVO = ClassUtils.createClassLoaderVO(classLoaderInfo.classLoader);
            classLoaderVO.setLoadedCount(classLoaderInfo.loadedClassCount());
            classLoaderVOs.add(classLoaderVO);
        }
        if (this.isTree) {
            classLoaderVOs = ClassLoaderCommand.processClassLoaderTree(classLoaderVOs);
        }
        process.appendResult(new ClassLoaderModel().setClassLoaders(classLoaderVOs).setTree(this.isTree));
        affect.rCnt(classLoaderInfos.size());
        process.appendResult(new RowAffectModel(affect));
        process.end();
    }

    private void processClassLoader(CommandProcess process, Instrumentation inst, ClassLoader targetClassLoader) {
        RowAffect affect = new RowAffect();
        if (targetClassLoader != null) {
            if (targetClassLoader instanceof URLClassLoader) {
                List<String> classLoaderUrls = ClassLoaderCommand.getClassLoaderUrls(targetClassLoader);
                affect.rCnt(classLoaderUrls.size());
                if (classLoaderUrls.isEmpty()) {
                    process.appendResult(new MessageModel("urls is empty."));
                } else {
                    process.appendResult(new ClassLoaderModel().setUrls(classLoaderUrls));
                    affect.rCnt(classLoaderUrls.size());
                }
            } else {
                process.appendResult(new MessageModel("not a URLClassLoader."));
            }
        }
        process.appendResult(new RowAffectModel(affect));
        process.end();
    }

    private void processResources(CommandProcess process, Instrumentation inst, ClassLoader targetClassLoader) {
        RowAffect affect = new RowAffect();
        int rowCount = 0;
        ArrayList<String> resources = new ArrayList<String>();
        if (targetClassLoader != null) {
            try {
                Enumeration<URL> urls = targetClassLoader.getResources(this.resource);
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    resources.add(url.toString());
                    ++rowCount;
                }
            }
            catch (Throwable e) {
                this.logger.warn("get resource failed, resource: {}", (Object)this.resource, (Object)e);
            }
        }
        affect.rCnt(rowCount);
        process.appendResult(new ClassLoaderModel().setResources(resources));
        process.appendResult(new RowAffectModel(affect));
        process.end();
    }

    private void processLoadClass(CommandProcess process, Instrumentation inst, ClassLoader targetClassLoader) {
        if (targetClassLoader != null) {
            try {
                Class<?> clazz = targetClassLoader.loadClass(this.loadClass);
                process.appendResult(new MessageModel("load class success."));
                ClassDetailVO classInfo = ClassUtils.createClassInfo(clazz, false);
                process.appendResult(new ClassLoaderModel().setLoadClass(classInfo));
            }
            catch (Throwable e) {
                this.logger.warn("load class error, class: {}", (Object)this.loadClass, (Object)e);
                process.end(-1, "load class error, class: " + this.loadClass + ", error: " + e.toString());
                return;
            }
        }
        process.end();
    }

    private void processAllClasses(CommandProcess process, Instrumentation inst) {
        RowAffect affect = new RowAffect();
        this.getAllClasses(this.hashCode, inst, affect, process);
        if (this.checkInterrupted(process)) {
            return;
        }
        process.appendResult(new RowAffectModel(affect));
        process.end();
    }

    private void getAllClasses(String hashCode, Instrumentation inst, RowAffect affect, CommandProcess process) {
        int hashCodeInt = -1;
        if (hashCode != null) {
            hashCodeInt = Integer.valueOf(hashCode, 16);
        }
        TreeSet bootstrapClassSet = new TreeSet(new Comparator<Class>(){

            @Override
            public int compare(Class o1, Class o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        Class[] allLoadedClasses = inst.getAllLoadedClasses();
        HashMap<ClassLoader, TreeSet<Class>> classLoaderClassMap = new HashMap<ClassLoader, TreeSet<Class>>();
        for (Class clazz : allLoadedClasses) {
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader == null) {
                if (hashCode != null) continue;
                bootstrapClassSet.add(clazz);
                continue;
            }
            if (hashCode != null && classLoader.hashCode() != hashCodeInt) continue;
            TreeSet<Class> classSet = (TreeSet<Class>)classLoaderClassMap.get(classLoader);
            if (classSet == null) {
                classSet = new TreeSet<Class>(new Comparator<Class<?>>(){

                    @Override
                    public int compare(Class<?> o1, Class<?> o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                classLoaderClassMap.put(classLoader, classSet);
            }
            classSet.add(clazz);
        }
        int pageSize = 256;
        this.processClassSet(process, ClassUtils.createClassLoaderVO(null), bootstrapClassSet, pageSize, affect);
        for (Map.Entry entry : classLoaderClassMap.entrySet()) {
            if (this.checkInterrupted(process)) {
                return;
            }
            ClassLoader classLoader = (ClassLoader)entry.getKey();
            SortedSet classSet = (SortedSet)entry.getValue();
            this.processClassSet(process, ClassUtils.createClassLoaderVO(classLoader), classSet, pageSize, affect);
        }
    }

    private void processClassSet(final CommandProcess process, final ClassLoaderVO classLoaderVO, Collection<Class<?>> classes, int pageSize, final RowAffect affect) {
        ResultUtils.processClassNames(classes, pageSize, new ResultUtils.PaginationHandler<List<String>>(){

            @Override
            public boolean handle(List<String> classNames, int segment) {
                process.appendResult(new ClassLoaderModel().setClassSet(new ClassSetVO(classLoaderVO, classNames, segment)));
                affect.rCnt(classNames.size());
                return !ClassLoaderCommand.this.checkInterrupted(process);
            }
        });
    }

    private boolean checkInterrupted(CommandProcess process) {
        if (!process.isRunning()) {
            return true;
        }
        if (this.isInterrupted) {
            process.end(-1, "Processing has been interrupted");
            return true;
        }
        return false;
    }

    private static List<String> getClassLoaderUrls(ClassLoader classLoader) {
        URLClassLoader cl;
        URL[] urls;
        ArrayList<String> urlStrs = new ArrayList<String>();
        if (classLoader instanceof URLClassLoader && (urls = (cl = (URLClassLoader)classLoader).getURLs()) != null) {
            for (URL url : urls) {
                urlStrs.add(url.toString());
            }
        }
        return urlStrs;
    }

    private static List<ClassLoaderVO> processClassLoaderTree(List<ClassLoaderVO> classLoaders) {
        ArrayList<ClassLoaderVO> rootClassLoaders = new ArrayList<ClassLoaderVO>();
        ArrayList<ClassLoaderVO> parentNotNullClassLoaders = new ArrayList<ClassLoaderVO>();
        for (ClassLoaderVO classLoaderVO : classLoaders) {
            if (classLoaderVO.getParent() == null) {
                rootClassLoaders.add(classLoaderVO);
                continue;
            }
            parentNotNullClassLoaders.add(classLoaderVO);
        }
        for (ClassLoaderVO classLoaderVO : rootClassLoaders) {
            ClassLoaderCommand.buildTree(classLoaderVO, parentNotNullClassLoaders);
        }
        return rootClassLoaders;
    }

    private static void buildTree(ClassLoaderVO parent, List<ClassLoaderVO> parentNotNullClassLoaders) {
        for (ClassLoaderVO classLoaderVO : parentNotNullClassLoaders) {
            if (!parent.getName().equals(classLoaderVO.getParent())) continue;
            parent.addChild(classLoaderVO);
            ClassLoaderCommand.buildTree(classLoaderVO, parentNotNullClassLoaders);
        }
    }

    private static Set<ClassLoader> getAllClassLoaders(Instrumentation inst, Filter ... filters) {
        HashSet<ClassLoader> classLoaderSet = new HashSet<ClassLoader>();
        for (Class clazz : inst.getAllLoadedClasses()) {
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader == null || !ClassLoaderCommand.shouldInclude(classLoader, filters)) continue;
            classLoaderSet.add(classLoader);
        }
        return classLoaderSet;
    }

    private static List<ClassLoaderInfo> getAllClassLoaderInfo(Instrumentation inst, Filter ... filters) {
        ClassLoader classLoader;
        ClassLoaderInfo bootstrapInfo = new ClassLoaderInfo(null);
        HashMap<ClassLoader, ClassLoaderInfo> loaderInfos = new HashMap<ClassLoader, ClassLoaderInfo>();
        for (Class clazz : inst.getAllLoadedClasses()) {
            classLoader = clazz.getClassLoader();
            if (classLoader == null) {
                bootstrapInfo.increase();
                continue;
            }
            if (!ClassLoaderCommand.shouldInclude(classLoader, filters)) continue;
            ClassLoaderInfo loaderInfo = (ClassLoaderInfo)loaderInfos.get(classLoader);
            if (loaderInfo == null) {
                loaderInfo = new ClassLoaderInfo(classLoader);
                loaderInfos.put(classLoader, loaderInfo);
                for (ClassLoader parent = classLoader.getParent(); parent != null; parent = parent.getParent()) {
                    ClassLoaderInfo parentLoaderInfo = (ClassLoaderInfo)loaderInfos.get(parent);
                    if (parentLoaderInfo != null) continue;
                    parentLoaderInfo = new ClassLoaderInfo(parent);
                    loaderInfos.put(parent, parentLoaderInfo);
                }
            }
            loaderInfo.increase();
        }
        ArrayList sunClassLoaderList = new ArrayList();
        ArrayList otherClassLoaderList = new ArrayList();
        for (Map.Entry entry : loaderInfos.entrySet()) {
            classLoader = (ClassLoader)entry.getKey();
            if (classLoader.getClass().getName().startsWith("sun.")) {
                sunClassLoaderList.add(entry.getValue());
                continue;
            }
            otherClassLoaderList.add(entry.getValue());
        }
        Collections.sort(sunClassLoaderList);
        Collections.sort(otherClassLoaderList);
        ArrayList<ClassLoaderInfo> result = new ArrayList<ClassLoaderInfo>();
        result.add(bootstrapInfo);
        result.addAll(otherClassLoaderList);
        result.addAll(sunClassLoaderList);
        return result;
    }

    private static boolean shouldInclude(ClassLoader classLoader, Filter ... filters) {
        if (filters == null) {
            return true;
        }
        for (Filter filter : filters) {
            if (filter.accept(classLoader)) continue;
            return false;
        }
        return true;
    }

    private static class ClassLoaderInterruptHandler
    implements Handler<Void> {
        private ClassLoaderCommand command;

        public ClassLoaderInterruptHandler(ClassLoaderCommand command) {
            this.command = command;
        }

        @Override
        public void handle(Void event) {
            this.command.isInterrupted = true;
        }
    }

    private static class ValueComparator
    implements Comparator<String> {
        private Map<String, ClassLoaderStat> unsortedStats;

        ValueComparator(Map<String, ClassLoaderStat> stats) {
            this.unsortedStats = stats;
        }

        @Override
        public int compare(String o1, String o2) {
            if (null == this.unsortedStats) {
                return -1;
            }
            if (!this.unsortedStats.containsKey(o1)) {
                return 1;
            }
            if (!this.unsortedStats.containsKey(o2)) {
                return -1;
            }
            return this.unsortedStats.get(o2).getLoadedCount() - this.unsortedStats.get(o1).getLoadedCount();
        }
    }

    public static class ClassLoaderStat {
        private int loadedCount;
        private int numberOfInstance;

        void addLoadedCount(int count) {
            this.loadedCount += count;
        }

        void addNumberOfInstance(int count) {
            this.numberOfInstance += count;
        }

        public int getLoadedCount() {
            return this.loadedCount;
        }

        public int getNumberOfInstance() {
            return this.numberOfInstance;
        }
    }

    private static class SunReflectionClassLoaderFilter
    implements Filter {
        private static final List<String> REFLECTION_CLASSLOADERS = Arrays.asList("sun.reflect.DelegatingClassLoader", "jdk.internal.reflect.DelegatingClassLoader");

        private SunReflectionClassLoaderFilter() {
        }

        @Override
        public boolean accept(ClassLoader classLoader) {
            return !REFLECTION_CLASSLOADERS.contains(classLoader.getClass().getName());
        }
    }

    private static interface Filter {
        public boolean accept(ClassLoader var1);
    }

    private static class ClassLoaderInfo
    implements Comparable<ClassLoaderInfo> {
        private ClassLoader classLoader;
        private int loadedClassCount = 0;

        ClassLoaderInfo(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public String getName() {
            if (this.classLoader != null) {
                return this.classLoader.toString();
            }
            return "BootstrapClassLoader";
        }

        String hashCodeStr() {
            if (this.classLoader != null) {
                return "" + Integer.toHexString(this.classLoader.hashCode());
            }
            return "null";
        }

        void increase() {
            ++this.loadedClassCount;
        }

        int loadedClassCount() {
            return this.loadedClassCount;
        }

        ClassLoader parent() {
            return this.classLoader == null ? null : this.classLoader.getParent();
        }

        String parentStr() {
            if (this.classLoader == null) {
                return "null";
            }
            ClassLoader parent = this.classLoader.getParent();
            if (parent == null) {
                return "null";
            }
            return parent.toString();
        }

        @Override
        public int compareTo(ClassLoaderInfo other) {
            if (other == null) {
                return -1;
            }
            if (other.classLoader == null) {
                return -1;
            }
            if (this.classLoader == null) {
                return -1;
            }
            return this.classLoader.getClass().getName().compareTo(other.classLoader.getClass().getName());
        }
    }
}

