/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bytekit.asm.interceptor.annotation;

import com.alibaba.bytekit.asm.binding.Binding;
import com.alibaba.bytekit.asm.binding.ThrowableBinding;
import com.alibaba.bytekit.asm.interceptor.InterceptorMethodConfig;
import com.alibaba.bytekit.asm.interceptor.annotation.BindingParserUtils;
import com.alibaba.bytekit.asm.interceptor.annotation.ExceptionHandler;
import com.alibaba.bytekit.asm.interceptor.annotation.None;
import com.alibaba.bytekit.utils.AnnotationUtils;
import com.alibaba.bytekit.utils.ReflectionUtils;
import com.alibaba.deps.org.objectweb.asm.Type;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;

public class ExceptionHandlerUtils {
    public static InterceptorMethodConfig errorHandlerMethodConfig(Class<?> suppress, Class<?> handlerClass) {
        final InterceptorMethodConfig errorHandlerMethodConfig = new InterceptorMethodConfig();
        if (suppress.equals(None.class)) {
            suppress = Throwable.class;
        }
        errorHandlerMethodConfig.setSuppress(Type.getType(suppress).getInternalName());
        if (!handlerClass.equals(Void.class)) {
            ReflectionUtils.doWithMethods(handlerClass, new ReflectionUtils.MethodCallback(){

                @Override
                public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                    for (Annotation onMethodAnnotation : method.getAnnotations()) {
                        if (!ExceptionHandler.class.isAssignableFrom(onMethodAnnotation.annotationType())) continue;
                        if (!Modifier.isStatic(method.getModifiers())) {
                            throw new IllegalArgumentException("method must be static. method: " + method);
                        }
                        ExceptionHandler handler = (ExceptionHandler)onMethodAnnotation;
                        errorHandlerMethodConfig.setInline(handler.inline());
                        List<Binding> errorHandlerBindings = BindingParserUtils.parseBindings(method);
                        if (errorHandlerBindings.size() == 0) {
                            throw new IllegalArgumentException("error handler bingins must have at least a binding");
                        }
                        if (!(errorHandlerBindings.get(0) instanceof ThrowableBinding)) {
                            throw new IllegalArgumentException("error handler bingins first binding must be ThrowableBinding.");
                        }
                        errorHandlerBindings.remove(0);
                        errorHandlerMethodConfig.setBindings(errorHandlerBindings);
                        errorHandlerMethodConfig.setOwner(Type.getInternalName(method.getDeclaringClass()));
                        errorHandlerMethodConfig.setMethodName(method.getName());
                        errorHandlerMethodConfig.setMethodDesc(Type.getMethodDescriptor(method));
                    }
                }
            }, new ReflectionUtils.MethodFilter(){

                @Override
                public boolean matches(Method method) {
                    return AnnotationUtils.findAnnotation(method, ExceptionHandler.class) != null;
                }
            });
        }
        if (errorHandlerMethodConfig.getMethodDesc() == null) {
            return null;
        }
        return errorHandlerMethodConfig;
    }
}

