package com.ruoyi.system.service.operatingmanage.impl;

import com.ruoyi.common.constant.BsConstants;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.TimeUtils;
import com.ruoyi.system.domain.operatingmanage.TOperatingmanageNews;
import com.ruoyi.system.domain.publicservice.TOtherappAttachment;
import com.ruoyi.system.domain.system.enums.AttachEnums;
import com.ruoyi.system.mapper.operatingmanage.TOperatingmanageNewsMapper;
import com.ruoyi.system.mapper.publicservice.TOtherappAttachmentMapper;
import com.ruoyi.system.service.operatingmanage.TOperatingmanageNewsService;
import com.ruoyi.system.service.publicservice.TOtherappAttachmentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 新闻表
 * @author wujm<wujm@eazytec.com>
 */
@Service
public class TOperatingmanageNewsServiceImpl implements TOperatingmanageNewsService {
	private final Logger logger = LoggerFactory.getLogger(this.getClass());

	@Resource
	private TOperatingmanageNewsMapper tOperatingmanageNewsMapper;

	@Autowired
	private TOtherappAttachmentService itOtherappAttachmentService;

	@Autowired
	private TOtherappAttachmentMapper tOtherappAttachmentMapper;

	/** 基础功能不要直接写实现 */
	/**
	* 列表
	* @return
	*/
	private List<TOperatingmanageNews> list(TOperatingmanageNews tOperatingmanageNews) {
		return tOperatingmanageNewsMapper.list(tOperatingmanageNews);
	}

	/**
	* 查询
	* @param id
	*/
	private TOperatingmanageNews getObjectById(Long id) {
		return tOperatingmanageNewsMapper.getObjectById(id);
	}

    /**
     * 分页查询
     * @param tOperatingmanageNews
     * @return
     */
	@Override
	public List<TOperatingmanageNews> listTOperatingmanageNews(TOperatingmanageNews tOperatingmanageNews) {
		List<TOperatingmanageNews> newsList = tOperatingmanageNewsMapper.list(tOperatingmanageNews);
		if (newsList.isEmpty()) {
			return newsList;
		}
		List<Long> aids = new ArrayList<>();
		newsList.forEach(e ->{
			aids.add(e.getNewsId());
		});
		List<TOtherappAttachment> attachmentList = itOtherappAttachmentService.listByBusinessIdAndType(aids, AttachEnums.AttachType.NEWS_COVER.name());
		Map<String,List<TOtherappAttachment>> attachmentMap = attachmentList.stream().collect(Collectors.groupingBy(TOtherappAttachment::getBusinessId));
		Date before3Date = DateUtils.parseDate(TimeUtils.minusDays(3L, TimeUtils.FormatEnum.FORMAT_DATA_TIME));
		newsList.forEach(e ->{
			if (attachmentMap.containsKey(e.getNewsId().toString())) {
				e.setAttachment(attachmentMap.get(e.getNewsId().toString()));
			}
			if (e.getCreateTime().before(before3Date)) {
				e.setNewFlag(1);
			}
		});
		return newsList;
	}

    /**
     * 新增
     * @param tOperatingmanageNews
     * @return
     */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public int saveTOperatingmanageNews(TOperatingmanageNews tOperatingmanageNews) {
		int count = tOperatingmanageNewsMapper.save(tOperatingmanageNews);
		for(TOtherappAttachment tOtherappAttachment : tOperatingmanageNews.getAttachment()) {
			tOtherappAttachment.setAttachType(AttachEnums.AttachType.NEWS_COVER.name());
			tOtherappAttachment.setBusinessId(tOperatingmanageNews.getNewsId().toString());
			tOtherappAttachmentMapper.insertSelective(tOtherappAttachment);
		}
		return count;
	}

    /**
     * 根据id查询
     * @param id
     * @return
     */
	@Override
	public TOperatingmanageNews getTOperatingmanageNewsById(Long id) {
		TOperatingmanageNews tOperatingmanageNews = this.getObjectById(id);
		if (StringUtils.isNull(tOperatingmanageNews)) {
			throw new ServiceException(BsConstants.ERROR_QUERY_NOT_FOUND);
		}
		List<Long> aids = new ArrayList<>();
		aids.add(tOperatingmanageNews.getNewsId());
		List<TOtherappAttachment> attachmentList = itOtherappAttachmentService.listByBusinessIdAndType(aids, AttachEnums.AttachType.NEWS_COVER.name());
		if (!attachmentList.isEmpty()) {
			tOperatingmanageNews.setAttachment(attachmentList);
		}
		return tOperatingmanageNews;
	}

    /**
     * 修改
     * @param tOperatingmanageNews
     * @return
     */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public int updateTOperatingmanageNews(TOperatingmanageNews tOperatingmanageNews) {
		itOtherappAttachmentService.deleteFiles(tOperatingmanageNews.getNewsId().toString(), AttachEnums.AttachType.NEWS_COVER.name());
		for(TOtherappAttachment attachment : tOperatingmanageNews.getAttachment()) {
			attachment.setAttachType(AttachEnums.AttachType.NEWS_COVER.name());
			attachment.setBusinessId(tOperatingmanageNews.getNewsId().toString());
			tOtherappAttachmentMapper.insertSelective(attachment);
		}
		return tOperatingmanageNewsMapper.update(tOperatingmanageNews);
	}

    /**
     * 删除
     * @param ids
     * @return
     */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public int batchRemove(Long[] ids) {
		int count = 0;
		for(Long id:ids) {
			// 删除附件
			itOtherappAttachmentService.deleteFiles(id.toString(), AttachEnums.AttachType.NEWS_COVER.name());
			// 删除新闻
			TOperatingmanageNews tOperatingmanageNews = new TOperatingmanageNews();
			tOperatingmanageNews.setNewsId(id);
			count += tOperatingmanageNewsMapper.remove(tOperatingmanageNews);
		}
		return count;
	}
	/**
	 * 修改基础信息，不处理附件
	 * @param tOperatingmanageNews
	 * @return
	 */
	@Override
	public int basicTOperatingmanageNews(TOperatingmanageNews tOperatingmanageNews) {
		return tOperatingmanageNewsMapper.update(tOperatingmanageNews);
	}

}
