package com.ruoyi.web.controller.grid;

import com.alibaba.fastjson2.JSON;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.grid.GridItemLib;
import com.ruoyi.system.service.grid.GridItemLibFacadeService;
import com.ruoyi.system.service.grid.GridItemLibService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;

/**
 * @Auther: hxc
 * @Date: 2019/2/28 0028 14:09
 * @Description: 网格信息表
 */
@Api(tags = "网格管理 - 事项库")
@RestController
@RequestMapping("/api/grid/itemLib")
public class GridItemLibController {
    @Autowired
    private GridItemLibFacadeService gridItemLibFacadeService;
    @Autowired
    private GridItemLibService gridItemLibService;

    //对内接口
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @ResponseBody
    public String list(@RequestParam("pageNum") int pageNum, @RequestParam("pageSize") int pageSize,
                       String sxfl, String sxmc) {

        AjaxResult result = new AjaxResult();
        gridItemLibFacadeService.getRoles(sxfl, sxmc, pageNum, pageSize, result);
        return JSON.toJSONString(result);
    }


    @RequestMapping(value = "/add", method = RequestMethod.POST)
    @ResponseBody
    public String add(@RequestBody GridItemLib lib) {
        lib.setId(UUID.randomUUID().toString());
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");//设置日期格式
        lib.setCreateTime(df.format(new Date()));
        int result = gridItemLibService.insert(lib);
        if (result == 1) {
            return JSON.toJSONString(AjaxResult.success("success", lib));
        } else {
            return JSON.toJSONString(AjaxResult.error(400, "fail"));
        }

    }


    @RequestMapping(value = "/delete", method = RequestMethod.GET)
    @ResponseBody
    public String delete(@RequestParam String id) {
        int result = gridItemLibService.deleteByStringPrimaryKey(id);
        if (result == 1) {
            return JSON.toJSONString(AjaxResult.success("success", id));
        } else {
            return JSON.toJSONString(AjaxResult.error(400, "fail"));
        }
    }


    @RequestMapping(value = "/update", method = RequestMethod.POST)
    @ResponseBody
    public String update(@RequestBody GridItemLib lib) {
        int result = gridItemLibService.updateByPrimaryKeySelective(lib);
        if (result == 1) {
            return JSON.toJSONString(AjaxResult.success("success", lib));
        } else {
            return JSON.toJSONString(AjaxResult.error(400, "fail"));
        }
    }

    @RequestMapping(value = "/countSxfl", method = RequestMethod.GET)
    @ResponseBody
    public String countSxfl() {
        AjaxResult result = new AjaxResult();
        gridItemLibFacadeService.countSxfl(result);
        return JSON.toJSONString(result);
    }

    @RequestMapping(value = "/countBySxfl", method = RequestMethod.GET)
    @ResponseBody
    public String countBySxfl() {
        AjaxResult result = new AjaxResult();
        gridItemLibFacadeService.countBySxfl(result);
        return JSON.toJSONString(result);
    }
}
