package com.ruoyi.system.service.task.impl;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.zqt.ZQTPageModel;
import com.ruoyi.system.domain.task.TkChengyunTask;
import com.ruoyi.system.domain.task.TkChengyunTaskExample;
import com.ruoyi.system.listener.MyBaseService;
import com.ruoyi.system.mapper.task.TkChengyunTaskMapper;
import com.ruoyi.system.service.BaseServiceImpl;
import com.ruoyi.system.service.other.BsCommonService;
import com.ruoyi.system.service.task.TkChengyunTaskService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Cesar
 * @date ${cTime}
 * @desc TkChengyunTaskService实现
 */
@Service
@MyBaseService
public class TkChengyunTaskServiceImpl extends BaseServiceImpl<TkChengyunTaskMapper, TkChengyunTask, TkChengyunTaskExample> implements TkChengyunTaskService {

    private static final Logger LOGGER = LoggerFactory.getLogger(TkChengyunTaskServiceImpl.class);

    @Autowired
    TkChengyunTaskMapper tkChengyunTaskMapper;

    @Autowired
    BsCommonService bsCommonService;

    @Override
    public void getRoles(String cedeventcode, String name, String isPush, Integer pageNum, Integer pageSize, AjaxResult result) {
        if (null == pageNum || pageNum <= 0) {
            pageNum = 1;
        }
        if (null == pageSize || pageSize <= 0) {
            pageSize = 10;
        }
        ZQTPageModel<TkChengyunTask> appPageModel = new ZQTPageModel<>();
        appPageModel.setRecordCount(0);
        appPageModel.setPageCount(0);
        appPageModel.setCurPage(pageNum);
        appPageModel.setItemList(new ArrayList<>());

        TkChengyunTaskExample example = new TkChengyunTaskExample();
        TkChengyunTaskExample.Criteria criteria = example.createCriteria();
        criteria.andComeFromEqualTo("13");
        if (StringUtils.isNotEmpty(isPush)) {
            if (Integer.valueOf(isPush).equals(2)) {
                criteria.andIssyncGreaterThanOrEqualTo(1);
            } else {
                criteria.andIspushEqualTo(Integer.valueOf(isPush)).andIssyncLessThan(1);
            }

        }
        if (StringUtils.isNotEmpty(cedeventcode)) {
            criteria.andCedeventcodeEqualTo(cedeventcode);
        }
        if (StringUtils.isNotEmpty(name)) {
            criteria.andNameLike("%" + name + "%");
        }

        example.setOrderByClause(" SFSJ DESC ");
        int count = countByExample(example);
        if (count <= 0) {
            result.buildSuccess("success", appPageModel);
            return;
        }

        List<TkChengyunTask> roles = selectByExampleWithBLOBsForStartPage(example, pageNum, pageSize);
        if (null == roles || roles.isEmpty()) {
            result.buildSuccess("success", appPageModel);
            return;
        }
        appPageModel.setCurPage(pageNum);
        appPageModel.setRecordCount(count);
        appPageModel.setPageCount((long) Math.ceil(1.0 * count / pageSize));
        appPageModel.setItemList(roles);
        result.buildSuccess("success", appPageModel);
    }


}
