package com.ruoyi.party.service.api;

import com.ruoyi.common.core.domain.entity.SysDictData;
import com.ruoyi.party.domain.PartyActivity;
import com.ruoyi.party.domain.vo.PartyActivityVO;

import java.util.List;
import java.util.Map;

/**
 * 党员活动Service接口
 * 
 * @author ruoyi
 * @date 2024-05-15
 */
public interface IPartyActivityService 
{
    /**
     * 查询党员活动
     * 
     * @param id 党员活动主键
     * @return 党员活动
     */
    public PartyActivityVO selectPartyActivityById(String id);

    /**
     * 查询党员活动列表
     * 
     * @param partyActivity 党员活动
     * @return 党员活动集合
     */
    List<PartyActivity> selectPartyActivityList(PartyActivity partyActivity);

    List<PartyActivity> convertData(List<PartyActivity> list, List<SysDictData> dataTypeList);

    /**
     * 新增党员活动
     * 
     * @param partyActivity 党员活动
     * @return 结果
     */
    public Boolean insertOrUpdatePartyActivity(PartyActivity partyActivity);

    /**
     * 修改党员活动
     * 
     * @param partyActivity 党员活动
     * @return 结果
     */
    public int updatePartyActivity(PartyActivity partyActivity);

    /**
     * 批量删除党员活动
     * 
     * @param ids 需要删除的党员活动主键集合
     * @return 结果
     */
    public int deletePartyActivityByIds(String[] ids);

    /**
     * 删除党员活动信息
     * 
     * @param id 党员活动主键
     * @return 结果
     */
    public int deletePartyActivityById(String id);

    List<Map<String,Object>> getPartyActivity(String orgId);

}
