package com.ruoyi.system.service.operatingmanage;


import com.github.pagehelper.PageInfo;
import com.ruoyi.system.domain.operatingmanage.WsImportantNews;
import com.ruoyi.system.domain.operatingmanage.WsImportantNewsExample;
import com.ruoyi.system.domain.operatingmanage.vo.WsImportantNewsExt;
import com.ruoyi.system.service.BaseService;

/**
* WsImportantNewsService接口
* Created by cesar.X on 2022/7/8.
*/
public interface WsImportantNewsService extends BaseService<WsImportantNews, WsImportantNewsExample> {

    /**
     * 新增要闻
     * @param wsImportantNews
     * @return
     */
    void addWsImportantNews(WsImportantNewsExt wsImportantNews);

    /**
     * 更新要闻
     * @param wsImportantNews
     * @return
     */
    void updateWsImportantNews(WsImportantNewsExt wsImportantNews);

    /**
     * 要闻详情
     * @param id
     * @return
     */
    public WsImportantNews getWsImportantNewsById(Long id);

    /**
     * 删除要闻
     * @param ids
     * @return
     */
    void batchRemove(Long[] ids);

    /**
     * 要闻列表
     * @param wsImportantNews
     * @return
     */
    PageInfo<WsImportantNews>  ListWsImportantNews(WsImportantNewsExt wsImportantNews);

}