package com.ruoyi.quartz.task;

import com.ruoyi.system.domain.zb.*;
import com.ruoyi.system.domain.zb.enums.WeekReportTypeEnum;
import com.ruoyi.system.domain.zb.request.WeekReportSaveRequest;
import com.ruoyi.system.domain.zb.vo.WeekReportDetail;
import com.ruoyi.system.mapper.zb.ZbAutoRecordMapper;
import com.ruoyi.system.mapper.zb.ZbReportRelationshipMapper;
import com.ruoyi.system.mapper.zb.ZbWeekReportMapper;
import com.ruoyi.system.service.zb.WeekReportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;

/**
 * * Author: brenda
 * * 2025/1/14
 **/
@EnableScheduling
@EnableAsync
@Component
public class WeekReportTask {

    @Autowired
    private ZbAutoRecordMapper zbAutoRecordMapper;
    @Autowired
    private ZbWeekReportMapper zbWeekReportMapper;
    @Autowired
    private WeekReportService weekReportService;
    @Autowired
    private ZbReportRelationshipMapper zbReportRelationshipMapper;

    @Async
    @Scheduled(cron = "0 0 8 * * 1")
    @Transactional
    public void execute(){
        ZbAutoRecordExample example = new ZbAutoRecordExample();
        ZbAutoRecordExample.Criteria criteria = example.createCriteria();
        criteria.andValidEqualTo((byte)1);
        List<ZbAutoRecord> autoRecordList = zbAutoRecordMapper.selectByExample(example);
        if(!CollectionUtils.isEmpty(autoRecordList)){
            ZbAutoRecord record = autoRecordList.get(0);
            ZbWeekReport weekReport = zbWeekReportMapper.selectByPrimaryKey(record.getReportId());
            if(weekReport != null){
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                String endDate = simpleDateFormat.format(weekReport.getEndDate());
                LocalDate endLocalDate = LocalDate.parse(endDate);
                int dayOfWeek = endLocalDate.getDayOfWeek().getValue();
                int dayNextWeek = (8-dayOfWeek)%7;
                LocalDate nextStartDate = endLocalDate.plusDays(dayNextWeek);
                LocalDate nextEndDate = nextStartDate.plusDays(7);
                ZoneId zoneId = ZoneId.systemDefault();
                // 将LocalDate转换为ZonedDateTime
                ZonedDateTime zonedDateTime = nextStartDate.atStartOfDay(zoneId);
                // 将ZonedDateTime转换为Date
                Date startDate = Date.from(zonedDateTime.toInstant());
                SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy");
                String newYear = simpleDateFormat2.format(startDate);
                if(!newYear.equals(weekReport.getYear())){
                    //新的一年，停止自动发布
                    record.setValid((byte)0);
                    zbAutoRecordMapper.updateByPrimaryKey(record);
                    return;
                }
                WeekReportSaveRequest request = new WeekReportSaveRequest();
                request.setStartDate(startDate);
                ZonedDateTime zonedDateTime2 = nextEndDate.atStartOfDay(zoneId);
                Date newEndDate = Date.from(zonedDateTime2.toInstant());
                request.setEndDate(newEndDate);
                Integer week = (Integer.parseInt(record.getLastWeek()) + 1);
                request.setWeek(String.valueOf(week));
                request.setYear(weekReport.getYear());
                request.setCreateTime(new Date());
                request.setCreateUser(weekReport.getCreateUser());
                request.setType(WeekReportTypeEnum.AUTO.getCode());
                request.setPublishFlag(1);
                request.setAutoFlag(1);
                request.setLeaderFillFlag(weekReport.getLeaderFillFlag());
                request.setShowFlag(weekReport.getShowFlag());
                request.setTitle(weekReport.getTitle().replace(weekReport.getWeek(), String.valueOf(week)));
                request.setDictId(weekReport.getDictId());
                request.setScheduled(true);
                String id = weekReportService.save(request);
                record.setLastWeek(String.valueOf(week));
                record.setLastReportId(id);
                zbAutoRecordMapper.updateByPrimaryKey(record);
            }
        }
    }
}
