package com.ruoyi.web.controller.stamp;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysDept;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.system.domain.stamp.request.CarDinnerExamineRequest;
import com.ruoyi.system.domain.stamp.request.StampExamineSaveRequest;
import com.ruoyi.system.domain.stamp.vo.StampExaminePageItem;
import com.ruoyi.system.service.stamp.StampExamineService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Date;

/**
 * * Author: brenda
 * * 2025/1/22
 **/
@Api(tags = "用章申请")
@RestController
@RequestMapping("/api/stamp/examine")
public class StampExamineController extends BaseController {

    @Autowired
    private StampExamineService stampExamineService;

    @PostMapping("/save")
    public AjaxResult save(@RequestBody StampExamineSaveRequest request){
        SysUser sysUser = getLoginUser().getUser();
        request.setCreateUser(sysUser.getUserId());
        request.setCreateTime(new Date());
        request.setCreateUserName(sysUser.getNickName());
        SysDept sysDept = sysUser.getDept();
        if(sysDept != null){
            request.setDepId(sysDept.getDeptId());
            request.setDepName(sysDept.getDeptName());
        }
        stampExamineService.save(request);
        return AjaxResult.success();
    }

    /**
     * 重新提交
     * @param request
     * @return
     */
    @PostMapping("/reSubmit")
    public AjaxResult reSubmit(@RequestBody StampExamineSaveRequest request){
        SysUser sysUser = getLoginUser().getUser();
        request.setCreateUser(sysUser.getUserId());
        request.setCreateTime(new Date());
        request.setCreateUserName(sysUser.getNickName());
        request.setUpdateTime(new Date());
        SysDept sysDept = sysUser.getDept();
        if(sysDept != null){
            request.setDepId(sysDept.getDeptId());
            request.setDepName(sysDept.getDeptName());
        }
        stampExamineService.reSubmit(request);
        return AjaxResult.success();
    }

    /**
     * 审批
     * 审批通过 F， 审批退回 B
     * @return
     */
    @PostMapping("/examine")
    public AjaxResult examine(@RequestBody CarDinnerExamineRequest request){
        request.setUserId(getUserId());
        stampExamineService.apply(request);
        return AjaxResult.success();
    }

    @GetMapping("/detail/{id}")
    public AjaxResult detail(@PathVariable("id")String id){
        return AjaxResult.success(stampExamineService.detail(id, getUserId()));
    }

    @GetMapping("/page")
    public AjaxResult page(@RequestParam("pageNum") int pageNum, @RequestParam("pageSize") int pageSize,
                                      @RequestParam(value = "title", required = false)String title,
                           @RequestParam(value = "status", required = false)String status){
        PageHelper.startPage(pageNum, pageSize);
        PageInfo<StampExaminePageItem> pageInfo = stampExamineService.page(title,getUserId(), status);
        return AjaxResult.success(pageInfo);
    }

}
