/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.tunnel.client;

import com.alibaba.arthas.deps.io.netty.buffer.ByteBuf;
import com.alibaba.arthas.deps.io.netty.buffer.Unpooled;
import com.alibaba.arthas.deps.io.netty.channel.ChannelFuture;
import com.alibaba.arthas.deps.io.netty.channel.ChannelHandlerContext;
import com.alibaba.arthas.deps.io.netty.channel.ChannelPromise;
import com.alibaba.arthas.deps.io.netty.channel.SimpleChannelInboundHandler;
import com.alibaba.arthas.deps.io.netty.handler.codec.base64.Base64;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.QueryStringDecoder;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.QueryStringEncoder;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import com.alibaba.arthas.deps.io.netty.handler.timeout.IdleStateEvent;
import com.alibaba.arthas.deps.io.netty.util.CharsetUtil;
import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.alibaba.arthas.tunnel.client.ForwardClient;
import com.alibaba.arthas.tunnel.client.ProxyClient;
import com.alibaba.arthas.tunnel.client.TunnelClient;
import com.alibaba.arthas.tunnel.common.SimpleHttpResponse;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class TunnelClientSocketClientHandler
extends SimpleChannelInboundHandler<WebSocketFrame> {
    private static final Logger logger = LoggerFactory.getLogger(TunnelClientSocketClientHandler.class);
    private final TunnelClient tunnelClient;
    private ChannelPromise registerPromise;

    public TunnelClientSocketClientHandler(TunnelClient tunnelClient) {
        this.tunnelClient = tunnelClient;
    }

    public ChannelFuture registerFuture() {
        return this.registerPromise;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        this.registerPromise = ctx.newPromise();
    }

    @Override
    public void channelRead0(ChannelHandlerContext ctx, WebSocketFrame frame) throws Exception {
        if (frame instanceof TextWebSocketFrame) {
            TextWebSocketFrame textFrame = (TextWebSocketFrame)frame;
            String text = textFrame.text();
            logger.info("receive TextWebSocketFrame: {}", (Object)text);
            QueryStringDecoder queryDecoder = new QueryStringDecoder(text);
            Map<String, List<String>> parameters = queryDecoder.parameters();
            List<String> methodList = parameters.get("method");
            String method = null;
            if (methodList != null && !methodList.isEmpty()) {
                method = methodList.get(0);
            }
            if ("agentRegister".equals(method)) {
                List<String> idList = parameters.get("id");
                if (idList != null && !idList.isEmpty()) {
                    this.tunnelClient.setId(idList.get(0));
                }
                this.tunnelClient.setConnected(true);
                this.registerPromise.setSuccess();
            }
            if ("startTunnel".equals(method)) {
                QueryStringEncoder queryEncoder = new QueryStringEncoder(this.tunnelClient.getTunnelServerUrl());
                queryEncoder.addParam("method", "openTunnel");
                queryEncoder.addParam("clientConnectionId", parameters.get("clientConnectionId").get(0));
                queryEncoder.addParam("id", parameters.get("id").get(0));
                URI forwardUri = queryEncoder.toUri();
                logger.info("start ForwardClient, uri: {}", (Object)forwardUri);
                try {
                    ForwardClient forwardClient = new ForwardClient(forwardUri);
                    forwardClient.start();
                }
                catch (Throwable e) {
                    logger.error("start ForwardClient error, forwardUri: {}", (Object)forwardUri, (Object)e);
                }
            }
            if ("httpProxy".equals(method)) {
                ProxyClient proxyClient = new ProxyClient();
                List<String> targetUrls = parameters.get("targetUrl");
                List<String> requestIDs = parameters.get("requestId");
                String id = null;
                if (requestIDs != null && !requestIDs.isEmpty()) {
                    id = requestIDs.get(0);
                }
                if (id == null) {
                    logger.error("error, http proxy need {}", (Object)"requestId");
                    return;
                }
                if (targetUrls != null && !targetUrls.isEmpty()) {
                    String targetUrl = targetUrls.get(0);
                    SimpleHttpResponse simpleHttpResponse = proxyClient.query(targetUrl);
                    ByteBuf byteBuf = Base64.encode(Unpooled.wrappedBuffer(SimpleHttpResponse.toBytes(simpleHttpResponse)));
                    String requestData = byteBuf.toString(CharsetUtil.UTF_8);
                    QueryStringEncoder queryEncoder = new QueryStringEncoder("");
                    queryEncoder.addParam("method", "httpProxy");
                    queryEncoder.addParam("requestId", id);
                    queryEncoder.addParam("responseData", requestData);
                    String url = queryEncoder.toString();
                    ctx.writeAndFlush(new TextWebSocketFrame(url));
                }
            }
        }
    }

    @Override
    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        this.tunnelClient.setConnected(false);
        ctx.channel().eventLoop().schedule(new Runnable(){

            @Override
            public void run() {
                logger.error("try to reconnect to tunnel server, uri: {}", (Object)TunnelClientSocketClientHandler.this.tunnelClient.getTunnelServerUrl());
                try {
                    TunnelClientSocketClientHandler.this.tunnelClient.connect(true);
                }
                catch (Throwable e) {
                    logger.error("reconnect error", e);
                }
            }
        }, (long)this.tunnelClient.getReconnectDelay(), TimeUnit.SECONDS);
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            ctx.writeAndFlush(new PingWebSocketFrame());
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.error("TunnelClient error, tunnel server url: " + this.tunnelClient.getTunnelServerUrl(), cause);
        if (!this.registerPromise.isDone()) {
            this.registerPromise.setFailure(cause);
        }
        ctx.close();
    }
}

