package com.ruoyi.party.service.impl;

import com.ruoyi.common.annotation.DataSource;
import com.ruoyi.common.enums.ClickEnumType;
import com.ruoyi.common.enums.DataSourceType;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.party.domain.ClickNumber;
import com.ruoyi.party.domain.vo.ClickNumberStatisticsVo;
import com.ruoyi.party.mapper.ClickNumberMapper;
import com.ruoyi.party.service.api.IClickNumberService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;

/**
 * 点击次数Service业务层处理
 * 
 * @author ruoyi
 * @date 2024-05-24
 */
@Service
@DataSource(value = DataSourceType.SLAVE)
public class ClickNumberServiceImpl implements IClickNumberService
{
    @Autowired
    private ClickNumberMapper clickNumberMapper;

    /**
     * 查询点击次数
     * 
     * @param id 点击次数主键
     * @return 点击次数
     */
    @Override
    public ClickNumber selectClickNumberById(Long id)
    {
        return clickNumberMapper.selectClickNumberById(id);
    }

    /**
     * 查询点击次数列表
     * 
     * @param clickNumber 点击次数
     * @return 点击次数
     */
    @Override
    public List<ClickNumber> selectClickNumberList(ClickNumber clickNumber)
    {
        return clickNumberMapper.selectClickNumberList(clickNumber);
    }

    /**
     * 新增点击次数
     * 
     * @param clickNumber 点击次数
     * @return 结果
     */
    @Override
    public int insertClickNumber(ClickNumber clickNumber)
    {
        clickNumber.setCreateTime(DateUtils.getNowDate());
        return clickNumberMapper.insertClickNumber(clickNumber);
    }

    /**
     * 修改点击次数
     * 
     * @param clickNumber 点击次数
     * @return 结果
     */
    @Override
    public int updateClickNumber(ClickNumber clickNumber)
    {
        return clickNumberMapper.updateClickNumber(clickNumber);
    }

    /**
     * 批量删除点击次数
     * 
     * @param ids 需要删除的点击次数主键
     * @return 结果
     */
    @Override
    public int deleteClickNumberByIds(Long[] ids)
    {
        return clickNumberMapper.deleteClickNumberByIds(ids);
    }

    /**
     * 删除点击次数信息
     * 
     * @param id 点击次数主键
     * @return 结果
     */
    @Override
    public int deleteClickNumberById(Long id)
    {
        return clickNumberMapper.deleteClickNumberById(id);
    }

    /**
     * 统计点击次数
     * @param type
     * @param businessKey
     * @return
     */
    @Override
    public ClickNumberStatisticsVo getClickNumberStatistics(String type, String businessKey) {
        ClickNumberStatisticsVo clickNumberStatisticsVo = new ClickNumberStatisticsVo();
        long count = clickNumberMapper.selectClickNumberStatisticsByTypeBusinessKey(type, businessKey);
        clickNumberStatisticsVo.setType(type);
        clickNumberStatisticsVo.setBusinessKey(businessKey);
        clickNumberStatisticsVo.setFrequency(count);
        clickNumberStatisticsVo.setTypeText(Objects.requireNonNull(Arrays.stream(ClickEnumType.values()).filter(x -> x.getType().equals(type)).findFirst().orElse(null)).getDescription());
        return clickNumberStatisticsVo;
    }
}
