package com.ruoyi.system.service.grid.impl;

import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.domain.grid.GridCompanyLawArchivesAttachment;
import com.ruoyi.system.domain.grid.GridCompanyLawArchivesAttachmentExample;
import com.ruoyi.system.listener.MyBaseService;
import com.ruoyi.system.mapper.grid.GridCompanyLawArchivesAttachmentMapper;
import com.ruoyi.system.service.BaseServiceImpl;
import com.ruoyi.system.service.grid.GridCompanyLawArchivesAttachmentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.UUID;

@Service
@MyBaseService
public class GridCompanyLawArchivesAttachmentServiceImpl extends BaseServiceImpl<GridCompanyLawArchivesAttachmentMapper, GridCompanyLawArchivesAttachment, GridCompanyLawArchivesAttachmentExample> implements GridCompanyLawArchivesAttachmentService {
    private static final Logger LOGGER = LoggerFactory.getLogger(GridCompanyLawArchivesAttachmentServiceImpl.class);

    @Autowired
    GridCompanyLawArchivesAttachmentMapper gridCompanyLawArchivesAttachmentMapper;

    @Override
    public List<GridCompanyLawArchivesAttachment> list(String archivesId) {
        GridCompanyLawArchivesAttachmentExample example = new GridCompanyLawArchivesAttachmentExample();
        example.createCriteria().andLawArchivesIdEqualTo(archivesId).andIsValidEqualTo("1");
        example.setOrderByClause(" create_time desc ");
        return gridCompanyLawArchivesAttachmentMapper.selectByExample(example);
    }

    @Override
    public void save(List<GridCompanyLawArchivesAttachment> attachments, String archivesId) {
        GridCompanyLawArchivesAttachmentExample example = new GridCompanyLawArchivesAttachmentExample();
        example.createCriteria().andLawArchivesIdEqualTo(archivesId).andIsValidEqualTo("1");
        int oldNum = (int) gridCompanyLawArchivesAttachmentMapper.countByExample(example);
        if (oldNum > 0) {
            GridCompanyLawArchivesAttachment param = new GridCompanyLawArchivesAttachment();
            param.setIsValid("0");
            gridCompanyLawArchivesAttachmentMapper.updateByExampleSelective(param, example);
        }
        if (!CollectionUtils.isEmpty(attachments)) {
            for (GridCompanyLawArchivesAttachment attachment : attachments) {
                if (StringUtils.isBlank(attachment.getFilename())
                        || StringUtils.isBlank(attachment.getFileurl())) {
                    throw new RuntimeException("保存失败：缺少必要参数");
                }
                attachment.setCreateTime(DateUtils.getTime());
                attachment.setId(UUID.randomUUID().toString());
                attachment.setLawArchivesId(archivesId);
                attachment.setIsValid("1");
                gridCompanyLawArchivesAttachmentMapper.insert(attachment);
            }
        }
    }
}
