package com.ruoyi.party.service.api;

import com.ruoyi.party.domain.ExcellentParty;

import java.util.List;

/**
 * 优秀党组织Service接口
 * 
 * @author ruoyi
 * @date 2024-05-20
 */
public interface IExcellentPartyService 
{
    /**
     * 查询优秀党组织
     * 
     * @param id 优秀党员主键
     * @return 优秀党员
     */
    public ExcellentParty selectExcellentPartyById(String id);

    /**
     * 查询优秀党组织列表
     * 
     * @param excellentParty 优秀党组织
     * @return 优秀党组织集合
     */
    public List<ExcellentParty> selectExcellentPartyList(ExcellentParty excellentParty);

    List<ExcellentParty> convertData(List<ExcellentParty> partyList);

    /**
     * 新增优秀党组织
     * 
     * @param excellentParty 优秀党员
     * @return 结果
     */
    public int insertExcellentParty(ExcellentParty excellentParty);

    /**
     * 修改优秀党组织
     * 
     * @param excellentParty 优秀党员
     * @return 结果
     */
    public int updateExcellentParty(ExcellentParty excellentParty);

    /**
     * 批量删除优秀党组织
     * 
     * @param ids 需要删除的优秀党组织主键集合
     * @return 结果
     */
    public int deleteExcellentPartyByIds(String[] ids);

    /**
     * 删除优秀党组织信息
     * 
     * @param id 优秀党组织主键
     * @return 结果
     */
    public int deleteExcellentPartyById(String id);

    public String getGoodPartyOrgCounts(Integer year,String beginDate);
}
