package com.ruoyi.web.controller.grid;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.domain.grid.GridWgNotice;
import com.ruoyi.system.service.grid.GridWgNoticeService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Date;

/**
 * 网格公告
 *
 * @author wujm<wujm @ eazytec.com>
 */
@Api(tags = "网格管理 - 网格公告")
@RestController
@RequestMapping("/api/grid/wgNotice")
public class GridWgNoticeController extends BaseController {

    @Autowired
    private GridWgNoticeService gridWgNoticeService;

    /**
     * 列表
     *
     * @param gridWgNotice
     * @return
     */
    @GetMapping
    public TableDataInfo list(GridWgNotice gridWgNotice) {
        startPage();
        return getDataTable(gridWgNoticeService.listGridWgNotice(gridWgNotice));
    }

    /**
     * 新增
     *
     * @param gridWgNotice
     * @return
     */
    @PostMapping()
    public AjaxResult save(@RequestBody GridWgNotice gridWgNotice) {

        gridWgNotice.setCreateBy(getUsername());
        gridWgNotice.setCreateTime(new Date());
        return toAjax(gridWgNoticeService.saveGridWgNotice(gridWgNotice));
    }

    /**
     * 根据id查询详情
     *
     * @param id
     * @return
     */
    @GetMapping(value = {"{id}"})
    public AjaxResult getById(@PathVariable("id") Long id) {
        GridWgNotice gridWgNotice = gridWgNoticeService.getGridWgNoticeById(id);
        if(gridWgNotice != null && StringUtils.isNotBlank(gridWgNotice.getNoticeContent())){
            String content = gridWgNotice.getNoticeContent().replaceAll("<image ", "<img ");
            gridWgNotice.setNoticeContent(content);
        }
        return AjaxResult.success(gridWgNotice);
    }

    /**
     * 修改
     *
     * @param gridWgNotice
     * @return
     */
    @PutMapping
    public AjaxResult update(@RequestBody GridWgNotice gridWgNotice) {
        gridWgNotice.setUpdateBy(getUsername());
        return toAjax(gridWgNoticeService.updateGridWgNotice(gridWgNotice));
    }

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @DeleteMapping
    public AjaxResult batchRemove(@RequestBody Long[] ids) {
        return toAjax(gridWgNoticeService.batchRemove(ids));
    }

}
